/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.training;

import java.io.File;
import java.util.List;
import javax.swing.JComboBox;
import org.encog.ml.MLMethod;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.buffer.BufferedMLDataSet;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.WorkBenchError;
import org.encog.workbench.dialogs.common.ComboBoxField;
import org.encog.workbench.dialogs.common.EncogPropertiesDialog;
import org.encog.workbench.frames.document.tree.ProjectEGFile;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.frames.document.tree.ProjectTraining;

public class MethodAndTrainingDialog
extends EncogPropertiesDialog {
    private ComboBoxField comboTraining;
    private ComboBoxField comboNetwork;
    private static final long serialVersionUID = 3506669325409959724L;
    private List<ProjectTraining> trainingSets;
    private List<ProjectEGFile> networks;

    public MethodAndTrainingDialog(boolean includePop) {
        super(EncogWorkBench.getInstance().getMainWindow());
        this.findData(includePop);
        this.setTitle("ML Method and Training Set");
        this.setSize(400, 400);
        this.setLocation(200, 200);
        this.comboTraining = new ComboBoxField("training set", "Training Set", true, this.trainingSets);
        this.addProperty(this.comboTraining);
        this.comboNetwork = new ComboBoxField("ML method", "ML Method", true, this.networks);
        this.addProperty(this.comboNetwork);
    }

    private void findData(boolean includePop) {
        this.trainingSets = EncogWorkBench.getInstance().getTrainingData("_train");
        this.networks = EncogWorkBench.getInstance().getMLMethods(includePop);
    }

    public Object getMethodOrPopulation() {
        if (this.comboNetwork.getSelectedValue() == null) {
            return null;
        }
        return ((ProjectEGFile)this.comboNetwork.getSelectedValue()).getObject();
    }

    public MLMethod getNetwork() {
        Object obj = this.getMethodOrPopulation();
        if (!(obj instanceof MLMethod)) {
            throw new WorkBenchError("This operation requires a MLMethod, not a \n" + obj.getClass().getName());
        }
        return (MLMethod)obj;
    }

    public void setMethod(ProjectFile method) {
        ((JComboBox)this.comboNetwork.getField()).setSelectedItem(method);
    }

    public MLDataSet getTrainingSet() {
        if (this.comboTraining.getSelectedValue() == null) {
            return null;
        }
        File file = ((ProjectTraining)this.comboTraining.getSelectedValue()).getFile();
        BufferedMLDataSet result = new BufferedMLDataSet(file);
        return result;
    }

    public ComboBoxField getComboTraining() {
        return this.comboTraining;
    }

    public ComboBoxField getComboNetwork() {
        return this.comboNetwork;
    }

    public List<ProjectTraining> getTrainingSets() {
        return this.trainingSets;
    }
}

