/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.population.epl;

import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.common.CheckField;
import org.encog.workbench.dialogs.common.DoubleField;
import org.encog.workbench.dialogs.common.IntegerField;
import org.encog.workbench.dialogs.training.DialogMaxError;

public class TrainEPLPopulationDialog
extends DialogMaxError {
    private static final long serialVersionUID = 1L;
    private final IntegerField complexityPenaltyThreshold;
    private final DoubleField complexityPenalty;
    private final IntegerField complexityPentaltyFullThreshold;
    private final DoubleField complexityFullPenalty;
    private final CheckField simplify;
    private final DoubleField mutateProbability;
    private final DoubleField constMutateProbability;
    private final DoubleField crossoverProbability;

    public TrainEPLPopulationDialog() {
        super(true);
        this.setTitle("Train EPL Population");
        this.complexityPenaltyThreshold = new IntegerField("complexity penalty threshold", "Complexity Penalty Threshold", true, -1, -1);
        this.addProperty(this.complexityPenaltyThreshold);
        this.complexityPenalty = new DoubleField("complexity penalty", "Complexity Penalty", true, -1, -1);
        this.addProperty(this.complexityPenalty);
        this.complexityPentaltyFullThreshold = new IntegerField("complexity pentalty full threshold", "Complexity Pentalty Full Threshold", true, -1, -1);
        this.addProperty(this.complexityPentaltyFullThreshold);
        this.complexityFullPenalty = new DoubleField("complexity full penalty", "Complexity Full Penalty", true, -1, -1);
        this.addProperty(this.complexityFullPenalty);
        this.simplify = new CheckField("simplify", "Simplify");
        this.addProperty(this.simplify);
        this.mutateProbability = new DoubleField("mutation probability", "Struct Mutation Probability", true, 0, 1);
        this.addProperty(this.mutateProbability);
        this.constMutateProbability = new DoubleField("mutation probability", "Const Mutation Probability", true, 0, 1);
        this.addProperty(this.constMutateProbability);
        this.crossoverProbability = new DoubleField("crossover probability", "Crossover Probability", true, 0, 1);
        this.addProperty(this.crossoverProbability);
        this.render();
        this.complexityPenaltyThreshold.setValue(10);
        this.complexityPenalty.setValue(0.2);
        this.complexityPentaltyFullThreshold.setValue(50);
        this.complexityFullPenalty.setValue(2.0);
        this.simplify.setValue(true);
        this.mutateProbability.setValue(0.1);
        this.constMutateProbability.setValue(0.1);
        this.crossoverProbability.setValue(0.8);
        this.getMaxError().setValue(EncogWorkBench.getInstance().getConfig().getDefaultError());
    }

    public IntegerField getComplexityPenaltyThreshold() {
        return this.complexityPenaltyThreshold;
    }

    public DoubleField getComplexityPenalty() {
        return this.complexityPenalty;
    }

    public IntegerField getComplexityPentaltyFullThreshold() {
        return this.complexityPentaltyFullThreshold;
    }

    public DoubleField getComplexityFullPenalty() {
        return this.complexityFullPenalty;
    }

    public CheckField getSimplify() {
        return this.simplify;
    }

    public DoubleField getMutateProbability() {
        return this.mutateProbability;
    }

    public DoubleField getCrossoverProbability() {
        return this.crossoverProbability;
    }

    public DoubleField getConstMutateProbability() {
        return this.constMutateProbability;
    }
}

