/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.error;

import java.awt.Frame;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.encog.Encog;
import org.encog.ml.data.MLDataSet;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.common.EncogCommonDialog;
import org.encog.workbench.dialogs.common.ValidationException;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.util.EncogFonts;

public class ErrorDialog
extends EncogCommonDialog {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final JTextArea text;
    private final JScrollPane scroll;

    public ErrorDialog(Frame owner, Throwable t, ProjectFile network, MLDataSet dataset) {
        super(owner);
        this.setSize(640, 480);
        this.setTitle("An Unhandled Error Occured");
        this.text = new JTextArea();
        this.text.setFont(EncogFonts.getInstance().getCodeFont());
        this.text.setEditable(false);
        this.scroll = new JScrollPane(this.text);
        this.getContentPane().add(this.scroll);
        StringBuilder message = new StringBuilder();
        message.append("We are very sorry but an unexpected error has occured." + NEW_LINE);
        message.append("Would you consider sending this information to us?" + NEW_LINE);
        message.append("No personal information will be transmitted, just what you see below." + NEW_LINE);
        message.append("This information is very useful to us to make Encog a better program." + NEW_LINE);
        message.append("----------------------------------------------------------------------" + NEW_LINE);
        if (network != null) {
            message.append(String.valueOf(network.toString()) + NEW_LINE);
            message.append("----------------------------------------------------------------------" + NEW_LINE);
        }
        if (dataset != null) {
            message.append(String.valueOf(dataset.toString()) + NEW_LINE);
            message.append("Input: " + dataset.getInputSize() + NEW_LINE);
            message.append("Output: " + dataset.getIdealSize() + NEW_LINE);
            message.append("----------------------------------------------------------------------" + NEW_LINE);
        }
        message.append("Encog Version: " + Encog.getInstance().getProperties().get("encog.version") + NEW_LINE);
        message.append("Encog Workbench Version: 3.4" + NEW_LINE);
        message.append("Java Version: " + System.getProperty("java.version") + NEW_LINE);
        message.append("Java Vendor: " + System.getProperty("java.vendor") + NEW_LINE);
        message.append("OS Name: " + System.getProperty("os.name") + NEW_LINE);
        message.append("OS Arch: " + System.getProperty("os.arch") + NEW_LINE);
        message.append("OS Version: " + System.getProperty("os.version") + NEW_LINE);
        message.append("Core Count: " + Runtime.getRuntime().availableProcessors() + NEW_LINE);
        Locale defaultLocale = Locale.getDefault();
        message.append("ISO3 Country: " + defaultLocale.getISO3Country() + NEW_LINE);
        message.append("Display Country: " + defaultLocale.getDisplayCountry() + NEW_LINE);
        message.append("Radix: " + DecimalFormatSymbols.getInstance().getDecimalSeparator() + NEW_LINE);
        message.append("Grouping: " + DecimalFormatSymbols.getInstance().getGroupingSeparator() + NEW_LINE);
        message.append("----------------------------------------------------------------------" + NEW_LINE);
        message.append(ErrorDialog.getCustomStackTrace(t));
        this.text.setText(message.toString());
        this.text.setSelectionStart(0);
        this.text.setSelectionEnd(0);
    }

    public static String getCustomStackTrace(Throwable aThrowable) {
        StringBuilder result = new StringBuilder("Exception: ");
        result.append(aThrowable.toString());
        result.append(NEW_LINE);
        StackTraceElement[] stackTraceElementArray = aThrowable.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            result.append(element);
            result.append(NEW_LINE);
            ++n2;
        }
        return result.toString();
    }

    @Override
    public void collectFields() throws ValidationException {
        this.getBodyPanel();
    }

    @Override
    public void setFields() {
    }

    public static void handleError(Throwable t, ProjectFile network, MLDataSet training) {
        t.printStackTrace();
        ErrorDialog dialog = new ErrorDialog((Frame)EncogWorkBench.getInstance().getMainWindow(), t, network, training);
        dialog.process();
        EncogWorkBench.getInstance().getMainWindow().endWait();
    }
}

