/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.createnetwork;

import java.awt.Frame;
import java.util.ArrayList;
import org.encog.mathutil.rbf.GaussianFunction;
import org.encog.mathutil.rbf.InverseMultiquadricFunction;
import org.encog.mathutil.rbf.MexicanHatFunction;
import org.encog.mathutil.rbf.MultiquadricFunction;
import org.encog.mathutil.rbf.RBFEnum;
import org.encog.workbench.dialogs.common.ComboBoxField;
import org.encog.workbench.dialogs.common.EncogPropertiesDialog;
import org.encog.workbench.dialogs.common.IntegerField;

public class CreateRBFDialog
extends EncogPropertiesDialog {
    private IntegerField inputCount;
    private IntegerField hiddenCount;
    private IntegerField outputCount;
    private ComboBoxField rbfTypeCombo;

    public CreateRBFDialog(Frame owner) {
        super(owner);
        ArrayList<String> rbfTypes = new ArrayList<String>();
        rbfTypes.add(GaussianFunction.class.getSimpleName());
        rbfTypes.add(MultiquadricFunction.class.getSimpleName());
        rbfTypes.add(InverseMultiquadricFunction.class.getSimpleName());
        rbfTypes.add(MexicanHatFunction.class.getSimpleName());
        this.setTitle("Create RBF Network");
        this.setSize(400, 400);
        this.setLocation(200, 200);
        this.inputCount = new IntegerField("input neurons", "Input Neuron Count", true, 1, 100000);
        this.addProperty(this.inputCount);
        this.hiddenCount = new IntegerField("input neurons", "Hidden Neuron Count", true, 1, 100000);
        this.addProperty(this.hiddenCount);
        this.outputCount = new IntegerField("input neurons", "Output Neuron Count", true, 1, 100000);
        this.addProperty(this.outputCount);
        this.rbfTypeCombo = new ComboBoxField("rbf type", "RBF Type", true, rbfTypes);
        this.addProperty(this.rbfTypeCombo);
        this.render();
    }

    public IntegerField getInputCount() {
        return this.inputCount;
    }

    public IntegerField getHiddenCount() {
        return this.hiddenCount;
    }

    public IntegerField getOutputCount() {
        return this.outputCount;
    }

    public RBFEnum getRBFType() {
        switch (this.rbfTypeCombo.getSelectedIndex()) {
            case 0: {
                return RBFEnum.Gaussian;
            }
            case 1: {
                return RBFEnum.Multiquadric;
            }
            case 2: {
                return RBFEnum.InverseMultiquadric;
            }
            case 3: {
                return RBFEnum.MexicanHat;
            }
        }
        return null;
    }
}

