/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.createnetwork;

import java.awt.Frame;
import java.util.List;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.ml.data.MLDataSet;
import org.encog.util.simple.EncogUtility;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.activation.ActivationDialog;
import org.encog.workbench.dialogs.common.BuildingListField;
import org.encog.workbench.dialogs.common.BuildingListListener;
import org.encog.workbench.dialogs.common.ComboBoxField;
import org.encog.workbench.dialogs.common.EncogPropertiesDialog;
import org.encog.workbench.dialogs.common.IntegerField;
import org.encog.workbench.dialogs.common.PopupField;
import org.encog.workbench.dialogs.common.PopupListener;
import org.encog.workbench.dialogs.createnetwork.NeuronRangeDialog;
import org.encog.workbench.frames.document.tree.ProjectTraining;

public class CreateAutomatic
extends EncogPropertiesDialog
implements BuildingListListener,
PopupListener {
    private final ComboBoxField comboTraining;
    private final BuildingListField hidden;
    private final PopupField activationField;
    private final IntegerField iterations;
    private final IntegerField weightTries;
    private final IntegerField windowSize;
    private ActivationFunction activationFunction;
    private List<ProjectTraining> trainingSets;

    public CreateAutomatic(Frame owner) {
        super(owner);
        this.setTitle("Create Network from Training");
        this.setSize(600, 400);
        this.setLocation(200, 200);
        this.findData();
        this.comboTraining = new ComboBoxField("training set", "Training Set", true, this.trainingSets);
        this.addProperty(this.comboTraining);
        this.hidden = new BuildingListField("hidden neurons", "Hidden Layer Counts");
        this.addProperty(this.hidden);
        this.activationField = new PopupField("activation", "Activation Function", true);
        this.addProperty(this.activationField);
        this.iterations = new IntegerField("iterations", "Training Iterations", true, 1, 100000);
        this.addProperty(this.iterations);
        this.weightTries = new IntegerField("weight tries", "Weights to Try", true, 1, 100000);
        this.addProperty(this.weightTries);
        this.windowSize = new IntegerField("window size", "Number of Top Networks", true, 1, 100000);
        this.addProperty(this.windowSize);
        this.render();
    }

    private void findData() {
        this.trainingSets = EncogWorkBench.getInstance().getTrainingData();
    }

    private String askNeurons(int layer) {
        NeuronRangeDialog dialog = new NeuronRangeDialog(EncogWorkBench.getInstance().getMainWindow());
        if (dialog.process()) {
            int high = dialog.getHigh().getValue();
            int low = dialog.getLow().getValue();
            if (low > high) {
                int temp = low;
                high = low;
                low = temp;
            }
            String str = "Hidden Layer " + layer + ": high=" + high + ",low=" + low + ".";
            return str;
        }
        return null;
    }

    @Override
    public void add(BuildingListField list, int index) {
        String str = this.askNeurons(list.getModel().size() + 1);
        if (str != null) {
            list.getModel().addElement(str);
        }
    }

    @Override
    public void del(BuildingListField list, int index) {
        if (index != -1) {
            list.getModel().remove(index);
        }
    }

    @Override
    public void edit(BuildingListField list, int index) {
        String str;
        if (index != -1 && (str = this.askNeurons(index + 1)) != null) {
            list.getModel().remove(index);
            list.getModel().add(index, str);
        }
    }

    public BuildingListField getHidden() {
        return this.hidden;
    }

    @Override
    public String popup(PopupField field) {
        ActivationDialog dialog = new ActivationDialog(EncogWorkBench.getInstance().getMainWindow());
        dialog.setActivation(this.activationFunction);
        if (!dialog.process()) {
            return null;
        }
        this.activationFunction = dialog.getActivation();
        return dialog.getActivation().getClass().getSimpleName();
    }

    public PopupField getActivationField() {
        return this.activationField;
    }

    public ActivationFunction getActivationFunction() {
        return this.activationFunction;
    }

    public void setActivationFunction(ActivationFunction activationFunction) {
        this.activationFunction = activationFunction;
        this.activationField.setValue(this.activationFunction.getClass().getSimpleName());
    }

    public IntegerField getIterations() {
        return this.iterations;
    }

    public MLDataSet getTraining() {
        ProjectTraining training = (ProjectTraining)this.comboTraining.getSelectedValue();
        return EncogUtility.loadEGB2Memory(training.getFile());
    }

    public IntegerField getWeightTries() {
        return this.weightTries;
    }

    public IntegerField getWindowSize() {
        return this.windowSize;
    }
}

