/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.createfile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.common.EncogCommonDialog;
import org.encog.workbench.dialogs.common.ValidationException;
import org.encog.workbench.dialogs.createfile.CreatePopulationType;

public class CreatePopulationDialog
extends EncogCommonDialog
implements ListSelectionListener {
    private DefaultListModel model = new DefaultListModel();
    private JList list = new JList(this.model);
    private JTextArea text = new JTextArea();
    private JScrollPane scroll1 = new JScrollPane(this.list);
    private JScrollPane scroll2 = new JScrollPane(this.text);
    private CreatePopulationType theType = CreatePopulationType.EPL;
    private static final long serialVersionUID = -5882600361686632769L;

    public CreatePopulationDialog() {
        super(EncogWorkBench.getInstance().getMainWindow());
        this.setTitle("Create a Population");
        JPanel top = new JPanel();
        JPanel bottom = new JPanel();
        this.setSize(500, 250);
        this.setLocation(50, 100);
        JPanel content = this.getBodyPanel();
        content.setLayout(new BorderLayout());
        top.setLayout(new GridLayout(1, 2));
        top.add(this.scroll1);
        top.add(this.scroll2);
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 0.0;
        content.add((Component)top, "Center");
        bottom.setLayout(gridBag);
        c.weightx = 1.0;
        content.add((Component)bottom, "South");
        this.model.addElement("NEAT Population");
        this.model.addElement("EPL Population");
        this.list.addListSelectionListener(this);
        this.text.setLineWrap(true);
        this.text.setWrapStyleWord(true);
        this.text.setEditable(false);
        this.scroll2.setHorizontalScrollBarPolicy(31);
    }

    @Override
    public void collectFields() throws ValidationException {
        switch (this.list.getSelectedIndex()) {
            case 0: {
                this.theType = CreatePopulationType.NEAT;
                break;
            }
            case 1: {
                this.theType = CreatePopulationType.EPL;
            }
        }
    }

    @Override
    public void setFields() {
        switch (this.theType) {
            case NEAT: {
                this.list.setSelectedIndex(0);
                break;
            }
            case EPL: {
                this.list.setSelectedIndex(1);
            }
        }
    }

    public CreatePopulationType getTheType() {
        return this.theType;
    }

    public void setTheType(CreatePopulationType t) {
        this.theType = t;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        switch (this.list.getSelectedIndex()) {
            case 0: {
                this.text.setText("Create NeuroEvolution of Augmenting Topologies (NEAT) population.  This will create a population of genomes that can be used to create NEAT neural networks.  NEAT networks are trained using a genetic algorithm both to vary weights and structures.");
                break;
            }
            case 1: {
                this.text.setText("Create a population of Encog Programming Language (EPL) programs.  EPL can represent mathematical expressions or programs.  EPL can be trained to perform regression, classification and other tasks.");
            }
        }
        this.text.setSelectionStart(0);
        this.text.setSelectionEnd(0);
    }
}

