/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.encog.workbench.dialogs.common.PropertiesField;
import org.encog.workbench.dialogs.common.ValidationException;

public class FolderField
extends PropertiesField
implements ActionListener {
    private String value;
    private JButton button;

    public FolderField(String name, String label, boolean required) {
        super(name, label, required);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        ((JTextField)this.getField()).setText(value);
    }

    @Override
    public int createField(JPanel panel, int x, int y, int width) {
        this.button = new JButton("Browse...");
        this.button.setSize(this.button.getPreferredSize());
        int buttonWidth = this.button.getWidth();
        this.button.setLocation(x + width - buttonWidth, y);
        JTextField field = new JTextField();
        field.setLocation(x, y);
        field.setSize(field.getPreferredSize());
        field.setSize(width - buttonWidth - 8, field.getHeight());
        this.setField(field);
        JLabel label = this.createLabel();
        label.setLocation(label.getX(), y);
        panel.add(label);
        panel.add(field);
        panel.add(this.button);
        this.button.addActionListener(this);
        return y + this.button.getHeight() + 2;
    }

    @Override
    public void collect() throws ValidationException {
        this.value = ((JTextField)this.getField()).getText();
        if (this.value.length() < 1 && this.isRequired()) {
            throw new ValidationException("The field " + this.getName() + " is required.");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.button) {
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(new File(((JTextField)this.getField()).getText()));
            fc.setFileSelectionMode(1);
            int result = fc.showOpenDialog(this.getOwner());
            if (result == 0) {
                String file = fc.getSelectedFile().getAbsolutePath();
                ((JTextField)this.getField()).setText(file);
            }
        }
    }
}

