/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.common;

import javax.swing.JTextField;
import org.encog.workbench.dialogs.common.PropertiesField;
import org.encog.workbench.dialogs.common.ValidationException;

public class DoubleField
extends PropertiesField {
    private final int min;
    private final int max;
    private double value;

    public DoubleField(String name, String label, boolean required, int min, int max) {
        super(name, label, required);
        this.max = max;
        this.min = min;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
        ((JTextField)this.getField()).setText("" + value);
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    @Override
    public void collect() throws ValidationException {
        double d = 0.0;
        try {
            String txt = ((JTextField)this.getField()).getText();
            d = Double.parseDouble(txt);
        }
        catch (NumberFormatException e) {
            throw new ValidationException("The field " + this.getName() + " requires a valid number.");
        }
        if (this.max > this.min && d < (double)this.min) {
            throw new ValidationException("Must enter a value above " + this.min + " for: " + this.getName());
        }
        if (this.max > this.min && d > (double)this.max) {
            throw new ValidationException("Must enter a value below " + this.max + " for: " + this.getName());
        }
        this.value = d;
    }
}

