/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.cloud;

import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.common.BuildingListField;
import org.encog.workbench.dialogs.common.BuildingListListener;
import org.encog.workbench.dialogs.common.EncogPropertiesDialog;

public class CloudIndicatorDialog
extends EncogPropertiesDialog
implements BuildingListListener {
    private BuildingListField sourceData;

    public CloudIndicatorDialog() {
        super(EncogWorkBench.getInstance().getMainWindow());
        this.setSize(640, 360);
        this.setTitle("Connect to External Indicator");
        this.sourceData = new BuildingListField("source fields", "Source Fields", 250);
        this.addProperty(this.sourceData);
        this.render();
        this.sourceData.getModel().addElement("HIGH");
        this.sourceData.getModel().addElement("LOW");
        this.sourceData.getModel().addElement("OPEN");
        this.sourceData.getModel().addElement("CLOSE");
        this.sourceData.getModel().addElement("VOL");
    }

    public List<String> getSourceData() {
        DefaultListModel ctrl = this.sourceData.getModel();
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < ctrl.getSize()) {
            result.add(ctrl.get(i).toString());
            ++i;
        }
        return result;
    }

    private String askIndicator() {
        String str = EncogWorkBench.displayInput("Indicator or fundamental?");
        return str;
    }

    @Override
    public void add(BuildingListField list, int index) {
        String str = this.askIndicator();
        if (str != null) {
            list.getModel().addElement(str);
        }
    }

    @Override
    public void del(BuildingListField list, int index) {
        if (index != -1) {
            list.getModel().remove(index);
        }
    }

    @Override
    public void edit(BuildingListField list, int index) {
        String str;
        if (index != -1 && (str = this.askIndicator()) != null) {
            list.getModel().remove(index);
            list.getModel().add(index, str);
        }
    }
}

