/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.binary;

import java.awt.Frame;
import java.util.ArrayList;
import org.encog.workbench.dialogs.common.CheckField;
import org.encog.workbench.dialogs.common.ComboBoxField;
import org.encog.workbench.dialogs.common.EncogPropertiesDialog;
import org.encog.workbench.dialogs.common.FileField;
import org.encog.workbench.dialogs.common.IntegerField;
import org.encog.workbench.frames.document.EncogDocumentFrame;

public class DialogExternal2Binary
extends EncogPropertiesDialog {
    private final IntegerField inputCount;
    private final IntegerField idealCount;
    private final FileField binaryFile;
    private final FileField externalFile;
    private final ComboBoxField fileType;
    private final CheckField containsSignificance;

    public DialogExternal2Binary(Frame owner) {
        super(owner);
        ArrayList<String> list = new ArrayList<String>();
        list.add("CSV");
        list.add("Excel (*.xlsx)");
        this.setSize(640, 200);
        this.setTitle("Convert Other Format File to Encog Binary Training");
        this.externalFile = new FileField("source file", "Source File", true, false, EncogDocumentFrame.CSV_FILTER);
        this.addProperty(this.externalFile);
        this.binaryFile = new FileField("target file", "Target Encog Binary File(*.egb)", true, true, EncogDocumentFrame.ENCOG_BINARY);
        this.addProperty(this.binaryFile);
        this.fileType = new ComboBoxField("type type", "Export File Type", true, list);
        this.addProperty(this.fileType);
        this.inputCount = new IntegerField("input count", "Input Count", true, 1, 10000);
        this.addProperty(this.inputCount);
        this.idealCount = new IntegerField("ideal count", "Ideal Count", true, 0, 10000);
        this.addProperty(this.idealCount);
        this.containsSignificance = new CheckField("contains significance column", "Significance Column Present");
        this.addProperty(this.containsSignificance);
        this.render();
    }

    public IntegerField getInputCount() {
        return this.inputCount;
    }

    public IntegerField getIdealCount() {
        return this.idealCount;
    }

    public FileField getBinaryFile() {
        return this.binaryFile;
    }

    public FileField getExternalFile() {
        return this.externalFile;
    }

    public ComboBoxField getFileType() {
        return this.fileType;
    }

    public final CheckField getContainsSignificance() {
        return this.containsSignificance;
    }
}

