/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.activation;

import java.awt.Frame;
import javax.swing.JDialog;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.workbench.dialogs.common.DecimalField;
import org.encog.workbench.dialogs.common.EncogPropertiesDialog;

public class ParamsDialog
extends EncogPropertiesDialog {
    DecimalField[] fields;

    public ParamsDialog(Frame owner, ActivationFunction activation) {
        super(owner);
        this.init(activation);
    }

    public ParamsDialog(JDialog owner, ActivationFunction activation) {
        super(owner);
        this.init(activation);
    }

    private void init(ActivationFunction activation) {
        this.setTitle(String.valueOf(activation.getClass().getSimpleName()) + " Parameters");
        this.setSize(400, 400);
        this.setLocation(200, 200);
        int len = activation.getParamNames().length;
        this.fields = new DecimalField[len];
        int i = 0;
        while (i < len) {
            String name = activation.getParamNames()[i];
            this.fields[i] = new DecimalField(name.toLowerCase(), name, true, -1.0, 1.0);
            this.addProperty(this.fields[i]);
            ++i;
        }
        this.render();
    }

    public void load(ActivationFunction activation) {
        int i = 0;
        while (i < activation.getParamNames().length) {
            this.fields[i].setValue(activation.getParams()[i]);
            ++i;
        }
    }

    public void save(ActivationFunction activation) {
        int i = 0;
        while (i < activation.getParamNames().length) {
            activation.getParams()[i] = this.fields[i].getValue();
            ++i;
        }
    }
}

