/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.normalize.target;

import org.encog.ml.data.MLDataSet;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.data.basic.BasicNeuralDataSet;
import org.encog.util.normalize.DataNormalization;
import org.encog.util.normalize.target.NormalizationStorage;

public class NormalizationStorageNeuralDataSet
implements NormalizationStorage {
    private int inputCount;
    private int idealCount;
    private MLDataSet dataset;

    public NormalizationStorageNeuralDataSet() {
    }

    public NormalizationStorageNeuralDataSet(int inputCount, int idealCount) {
        this.inputCount = inputCount;
        this.idealCount = idealCount;
        this.dataset = new BasicNeuralDataSet();
    }

    public NormalizationStorageNeuralDataSet(MLDataSet dataset) {
        this.dataset = dataset;
        this.inputCount = this.dataset.getInputSize();
        this.idealCount = this.dataset.getIdealSize();
    }

    @Override
    public void close() {
    }

    @Override
    public void open(DataNormalization norm) {
    }

    @Override
    public void write(double[] data, int inputCount) {
        if (this.idealCount == 0) {
            BasicNeuralData inputData = new BasicNeuralData(data);
            this.dataset.add(inputData);
        } else {
            BasicNeuralData inputData = new BasicNeuralData(this.inputCount);
            BasicNeuralData idealData = new BasicNeuralData(this.idealCount);
            int index = 0;
            int i = 0;
            while (i < this.inputCount) {
                inputData.setData(i, data[index++]);
                ++i;
            }
            i = 0;
            while (i < this.idealCount) {
                idealData.setData(i, data[index++]);
                ++i;
            }
            this.dataset.add(inputData, idealData);
        }
    }

    public MLDataSet getDataset() {
        return this.dataset;
    }
}

