/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.logging;

import java.text.NumberFormat;
import org.encog.mathutil.matrices.Matrix;

public final class DumpMatrix {
    public static final int MAX_PRECIS = 3;

    public static String dumpArray(double[] d) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(3);
        format.setMaximumFractionDigits(3);
        StringBuilder result = new StringBuilder();
        result.append("[");
        int i = 0;
        while (i < d.length) {
            if (i != 0) {
                result.append(",");
            }
            result.append(format.format(d[i]));
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    public static String dumpMatrix(Matrix matrix) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(3);
        format.setMaximumFractionDigits(3);
        StringBuilder result = new StringBuilder();
        result.append("==");
        result.append(matrix.toString());
        result.append("==\n");
        int row = 0;
        while (row < matrix.getRows()) {
            result.append("  [");
            int col = 0;
            while (col < matrix.getCols()) {
                if (col != 0) {
                    result.append(",");
                }
                result.append(format.format(matrix.get(row, col)));
                ++col;
            }
            result.append("]\n");
            ++row;
        }
        return result.toString();
    }

    private DumpMatrix() {
    }
}

