/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.http;

import java.io.File;
import java.io.IOException;
import java.net.URL;

public final class URLUtility {
    public static final int SPECIAL_CHAR_LIMIT = 255;
    public static final String INDEX_FILE = "index.html";

    public static URL constructURL(URL base, String url, boolean stripRef) throws IOException {
        URL result = new URL(base, url);
        String file = result.getFile();
        String protocol = result.getProtocol();
        String host = result.getHost();
        int port = result.getPort();
        String ref = result.getRef();
        StringBuilder sb = new StringBuilder(file);
        int index = sb.indexOf(" ");
        while (index != -1) {
            if (index != -1) {
                sb.replace(index, index + 1, "%20");
            }
            index = sb.indexOf(" ");
        }
        file = sb.toString();
        result = ref != null && !stripRef ? new URL(protocol, host, port, String.valueOf(file) + "#" + ref) : new URL(protocol, host, port, file);
        return result;
    }

    public static boolean containsInvalidURLCharacters(String url) {
        int i = 0;
        while (i < url.length()) {
            char ch = url.charAt(i);
            if (ch > '\u00ff') {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String convertFilename(String base, URL url, boolean mkdir) {
        int index2;
        StringBuilder result = new StringBuilder(base);
        StringBuilder path = new StringBuilder(url.getHost().replace('.', '_'));
        if (url.getFile().length() == 0) {
            path.append('/');
        } else {
            path.append(url.getFile());
        }
        if (result.charAt(result.length() - 1) != File.separatorChar) {
            result.append(File.separator);
        }
        int lastSlash = path.lastIndexOf("" + File.separatorChar);
        int lastDot = path.lastIndexOf(".");
        if (path.charAt(path.length() - 1) != '/' && lastSlash > lastDot) {
            path.append(File.pathSeparatorChar);
            path.append(INDEX_FILE);
        }
        lastSlash = path.lastIndexOf("/");
        String filename = "";
        if (lastSlash != -1) {
            filename = path.substring(1 + lastSlash);
            path = path.replace(1 + lastSlash, path.length(), "");
            if (filename.equals("")) {
                filename = INDEX_FILE;
            }
        }
        int index1 = 0;
        do {
            if ((index2 = path.indexOf("/", index1)) == -1) continue;
            String dirpart = path.substring(index1, index2);
            result.append(dirpart);
            result.append(File.separator);
            if (mkdir) {
                File f = new File(result.toString());
                f.mkdir();
            }
            index1 = index2 + 1;
        } while (index2 != -1);
        result.append(filename.replace('?', '_'));
        return result.toString();
    }

    private URLUtility() {
    }
}

