/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.source;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.encog.EncogError;
import org.encog.persist.source.ObtainInputStream;

public class ObtainFallbackStream
implements ObtainInputStream {
    private String datasetName;
    private String path;
    private Class resources;

    public ObtainFallbackStream(String thePath, String theDatasetName, Class theResources) {
        this.datasetName = theDatasetName;
        this.path = thePath;
        this.resources = theResources;
    }

    @Override
    public InputStream obtain() {
        File target = null;
        InputStream istream = this.resources.getResourceAsStream("/" + this.datasetName);
        if (istream == null) {
            try {
                target = new File(this.path, this.datasetName);
                return new FileInputStream(target);
            }
            catch (FileNotFoundException e) {
                throw new EncogError("Cannot access data set, make sure the resources are available: " + target);
            }
        }
        return istream;
    }
}

