/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.nm;

import org.encog.ml.MLMethod;
import org.encog.ml.TrainingImplementationType;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.train.BasicTraining;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.structure.NetworkCODEC;
import org.encog.neural.networks.training.propagation.TrainingContinuation;
import org.encog.util.EngineArray;

public class NelderMeadTraining
extends BasicTraining {
    private final BasicNetwork network;
    private double ynewlo;
    private boolean converged = false;
    private final double ccoeff = 0.5;
    private double del;
    private final double ecoeff = 2.0;
    private final double eps = 0.001;
    private int ihi;
    private int ilo;
    private int jcount;
    private int l;
    private final int nn;
    private final double[] p;
    private final double[] p2star;
    private final double[] pbar;
    private final double[] pstar;
    private final double rcoeff = 1.0;
    private final double rq;
    private final double[] y;
    private double y2star;
    private double ylo;
    private double ystar;
    private double z;
    private final double[] start;
    private final double[] trainedWeights;
    private final double[] step;
    private int konvge;

    public NelderMeadTraining(BasicNetwork network, MLDataSet training) {
        this(network, training, 100.0);
    }

    public NelderMeadTraining(BasicNetwork network, MLDataSet training, double stepValue) {
        super(TrainingImplementationType.OnePass);
        this.network = network;
        this.setTraining(training);
        this.start = NetworkCODEC.networkToArray(network);
        this.trainedWeights = NetworkCODEC.networkToArray(network);
        int n = this.start.length;
        this.p = new double[n * (n + 1)];
        this.pstar = new double[n];
        this.p2star = new double[n];
        this.pbar = new double[n];
        this.y = new double[n + 1];
        this.nn = n + 1;
        this.del = 1.0;
        this.rq = 1.0E-13 * (double)n;
        this.step = new double[NetworkCODEC.networkSize(network)];
        this.konvge = 500;
        this.jcount = 500;
        EngineArray.fill(this.step, stepValue);
    }

    @Override
    public boolean canContinue() {
        return false;
    }

    public double fn(double[] weights) {
        NetworkCODEC.arrayToNetwork(weights, this.network);
        return this.network.calculateError(this.getTraining());
    }

    @Override
    public MLMethod getMethod() {
        return this.network;
    }

    @Override
    public boolean isTrainingDone() {
        if (this.converged) {
            return true;
        }
        return super.isTrainingDone();
    }

    @Override
    public void iteration() {
        if (this.converged) {
            return;
        }
        int n = this.start.length;
        int i = 0;
        while (i < n) {
            this.p[i + n * n] = this.start[i];
            ++i;
        }
        this.y[n] = this.fn(this.start);
        int j = 0;
        while (j < n) {
            double x = this.start[j];
            this.start[j] = this.start[j] + this.step[j] * this.del;
            int i2 = 0;
            while (i2 < n) {
                this.p[i2 + j * n] = this.start[i2];
                ++i2;
            }
            this.y[j] = this.fn(this.start);
            this.start[j] = x;
            ++j;
        }
        this.ylo = this.y[0];
        this.ilo = 0;
        i = 1;
        while (i < this.nn) {
            if (this.y[i] < this.ylo) {
                this.ylo = this.y[i];
                this.ilo = i;
            }
            ++i;
        }
        block4: while (true) {
            this.ynewlo = this.y[0];
            this.ihi = 0;
            i = 1;
            while (i < this.nn) {
                if (this.ynewlo < this.y[i]) {
                    this.ynewlo = this.y[i];
                    this.ihi = i;
                }
                ++i;
            }
            i = 0;
            while (i < n) {
                this.z = 0.0;
                int j2 = 0;
                while (j2 < this.nn) {
                    this.z += this.p[i + j2 * n];
                    ++j2;
                }
                this.z -= this.p[i + this.ihi * n];
                this.pbar[i] = this.z / (double)n;
                ++i;
            }
            i = 0;
            while (i < n) {
                this.pstar[i] = this.pbar[i] + 1.0 * (this.pbar[i] - this.p[i + this.ihi * n]);
                ++i;
            }
            this.ystar = this.fn(this.pstar);
            if (this.ystar < this.ylo) {
                i = 0;
                while (i < n) {
                    this.p2star[i] = this.pbar[i] + 2.0 * (this.pstar[i] - this.pbar[i]);
                    ++i;
                }
                this.y2star = this.fn(this.p2star);
                if (this.ystar < this.y2star) {
                    i = 0;
                    while (i < n) {
                        this.p[i + this.ihi * n] = this.pstar[i];
                        ++i;
                    }
                    this.y[this.ihi] = this.ystar;
                } else {
                    i = 0;
                    while (i < n) {
                        this.p[i + this.ihi * n] = this.p2star[i];
                        ++i;
                    }
                    this.y[this.ihi] = this.y2star;
                }
            } else {
                this.l = 0;
                i = 0;
                while (i < this.nn) {
                    if (this.ystar < this.y[i]) {
                        ++this.l;
                    }
                    ++i;
                }
                if (1 < this.l) {
                    i = 0;
                    while (i < n) {
                        this.p[i + this.ihi * n] = this.pstar[i];
                        ++i;
                    }
                    this.y[this.ihi] = this.ystar;
                } else if (this.l == 0) {
                    i = 0;
                    while (i < n) {
                        this.p2star[i] = this.pbar[i] + 0.5 * (this.p[i + this.ihi * n] - this.pbar[i]);
                        ++i;
                    }
                    this.y2star = this.fn(this.p2star);
                    if (this.y[this.ihi] < this.y2star) {
                        j = 0;
                        while (j < this.nn) {
                            int i3 = 0;
                            while (i3 < n) {
                                this.p[i3 + j * n] = (this.p[i3 + j * n] + this.p[i3 + this.ilo * n]) * 0.5;
                                this.trainedWeights[i3] = this.p[i3 + j * n];
                                ++i3;
                            }
                            this.y[j] = this.fn(this.trainedWeights);
                            ++j;
                        }
                        this.ylo = this.y[0];
                        this.ilo = 0;
                        i = 1;
                        while (true) {
                            if (i >= this.nn) continue block4;
                            if (this.y[i] < this.ylo) {
                                this.ylo = this.y[i];
                                this.ilo = i;
                            }
                            ++i;
                        }
                    }
                    i = 0;
                    while (i < n) {
                        this.p[i + this.ihi * n] = this.p2star[i];
                        ++i;
                    }
                    this.y[this.ihi] = this.y2star;
                } else if (this.l == 1) {
                    i = 0;
                    while (i < n) {
                        this.p2star[i] = this.pbar[i] + 0.5 * (this.pstar[i] - this.pbar[i]);
                        ++i;
                    }
                    this.y2star = this.fn(this.p2star);
                    if (this.y2star <= this.ystar) {
                        i = 0;
                        while (i < n) {
                            this.p[i + this.ihi * n] = this.p2star[i];
                            ++i;
                        }
                        this.y[this.ihi] = this.y2star;
                    } else {
                        i = 0;
                        while (i < n) {
                            this.p[i + this.ihi * n] = this.pstar[i];
                            ++i;
                        }
                        this.y[this.ihi] = this.ystar;
                    }
                }
            }
            if (this.y[this.ihi] < this.ylo) {
                this.ylo = this.y[this.ihi];
                this.ilo = this.ihi;
            }
            --this.jcount;
            if (this.jcount > 0) continue;
            this.jcount = this.konvge;
            this.z = 0.0;
            i = 0;
            while (i < this.nn) {
                this.z += this.y[i];
                ++i;
            }
            double x = this.z / (double)this.nn;
            this.z = 0.0;
            int i4 = 0;
            while (i4 < this.nn) {
                this.z += Math.pow(this.y[i4] - x, 2.0);
                ++i4;
            }
            if (this.z <= this.rq) break;
        }
        i = 0;
        while (i < n) {
            this.trainedWeights[i] = this.p[i + this.ilo * n];
            ++i;
        }
        this.ynewlo = this.y[this.ilo];
        boolean fault = false;
        int i5 = 0;
        while (i5 < n) {
            this.del = this.step[i5] * 0.001;
            int n2 = i5;
            this.trainedWeights[n2] = this.trainedWeights[n2] + this.del;
            this.z = this.fn(this.trainedWeights);
            if (this.z < this.ynewlo) {
                fault = true;
                break;
            }
            this.trainedWeights[i5] = this.trainedWeights[i5] - this.del - this.del;
            this.z = this.fn(this.trainedWeights);
            if (this.z < this.ynewlo) {
                fault = true;
                break;
            }
            int n3 = i5++;
            this.trainedWeights[n3] = this.trainedWeights[n3] + this.del;
        }
        if (!fault) {
            this.converged = true;
        } else {
            i5 = 0;
            while (i5 < n) {
                this.start[i5] = this.trainedWeights[i5];
                ++i5;
            }
            this.del = 0.001;
        }
        this.setError(this.ynewlo);
        NetworkCODEC.arrayToNetwork(this.trainedWeights, this.network);
    }

    @Override
    public TrainingContinuation pause() {
        return null;
    }

    @Override
    public void resume(TrainingContinuation state) {
    }
}

