/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.prg.generator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.encog.EncogError;
import org.encog.mathutil.randomize.factory.BasicRandomFactory;
import org.encog.mathutil.randomize.factory.RandomFactory;
import org.encog.ml.CalculateScore;
import org.encog.ml.ea.exception.EACompileError;
import org.encog.ml.ea.exception.EARuntimeError;
import org.encog.ml.ea.population.Population;
import org.encog.ml.ea.species.Species;
import org.encog.ml.genetic.GeneticError;
import org.encog.ml.prg.EncogProgram;
import org.encog.ml.prg.EncogProgramContext;
import org.encog.ml.prg.ProgramNode;
import org.encog.ml.prg.expvalue.ValueType;
import org.encog.ml.prg.extension.ProgramExtensionTemplate;
import org.encog.ml.prg.generator.GenerateWorker;
import org.encog.ml.prg.generator.PrgGenerator;
import org.encog.ml.prg.train.PrgPopulation;
import org.encog.ml.prg.train.ZeroEvalScoreFunction;
import org.encog.util.concurrency.MultiThreadable;

public abstract class AbstractPrgGenerator
implements PrgGenerator,
MultiThreadable {
    private CalculateScore score = new ZeroEvalScoreFunction();
    private final EncogProgramContext context;
    private final int maxDepth;
    private double minConst = -10.0;
    private double maxConst = 10.0;
    private final boolean hasEnum;
    private int actualThreads;
    private int threads;
    private final Set<String> contents = new HashSet<String>();
    private RandomFactory randomFactory = new BasicRandomFactory();
    private int maxGenerationErrors = 500;

    public AbstractPrgGenerator(EncogProgramContext theContext, int theMaxDepth) {
        if (theContext.getFunctions().size() == 0) {
            throw new EncogError("There are no opcodes defined");
        }
        this.context = theContext;
        this.maxDepth = theMaxDepth;
        this.hasEnum = this.context.hasEnum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPopulationMember(PrgPopulation population, EncogProgram prg) {
        AbstractPrgGenerator abstractPrgGenerator = this;
        synchronized (abstractPrgGenerator) {
            Species defaultSpecies = population.getSpecies().get(0);
            prg.setSpecies(defaultSpecies);
            defaultSpecies.add(prg);
            this.contents.add(prg.dumpAsCommonExpression());
        }
    }

    public EncogProgram attemptCreateGenome(Random rnd, Population pop) {
        boolean done = false;
        EncogProgram result = null;
        int tries = this.maxGenerationErrors;
        while (!done) {
            double s;
            result = this.generate(rnd);
            result.setPopulation(pop);
            try {
                --tries;
                s = this.score.calculateScore(result);
            }
            catch (EARuntimeError e) {
                s = Double.NaN;
            }
            if (!pop.getRules().isValid(result)) {
                s = Double.NaN;
            }
            if (tries < 0) {
                throw new EncogError("Could not generate a valid genome after " + this.maxGenerationErrors + " tries.");
            }
            if (Double.isNaN(s) || Double.isInfinite(s) || this.contents.contains(result.dumpAsCommonExpression())) continue;
            done = true;
        }
        return result;
    }

    public ProgramNode createRandomNode(Random rnd, EncogProgram program, int depthRemaining, List<ValueType> types, boolean includeTerminal, boolean includeFunction) {
        if (depthRemaining == 0) {
            return this.createTerminalNode(rnd, program, types);
        }
        List<ProgramExtensionTemplate> opcodeSet = this.getContext().getFunctions().findOpcodes(types, this.getContext(), includeTerminal, includeFunction);
        ProgramExtensionTemplate temp = this.generateRandomOpcode(rnd, opcodeSet);
        if (temp == null) {
            throw new EACompileError("Trying to generate a random opcode when no opcodes exist.");
        }
        int childNodeCount = temp.getChildNodeCount();
        ProgramNode[] children = new ProgramNode[childNodeCount];
        if (temp.getNodeType().isOperator() && children.length >= 2) {
            List<ValueType> childTypes = temp.getParams().get(0).determineArgumentTypes(types);
            int i = 0;
            while (i < children.length) {
                children[i] = this.createNode(rnd, program, depthRemaining - 1, childTypes);
                ++i;
            }
        } else {
            int i = 0;
            while (i < children.length) {
                List<ValueType> childTypes = temp.getParams().get(i).determineArgumentTypes(types);
                children[i] = this.createNode(rnd, program, depthRemaining - 1, childTypes);
                ++i;
            }
        }
        ProgramNode result = new ProgramNode(program, temp, children);
        temp.randomize(rnd, types, result, this.getMinConst(), this.getMaxConst());
        return result;
    }

    public ProgramNode createTerminalNode(Random rnd, EncogProgram program, List<ValueType> types) {
        ProgramExtensionTemplate temp = this.generateRandomOpcode(rnd, this.getContext().getFunctions().findOpcodes(types, this.context, true, false));
        if (temp == null) {
            throw new EACompileError("No opcodes exist for the type: " + types.toString());
        }
        ProgramNode result = new ProgramNode(program, temp, new ProgramNode[0]);
        temp.randomize(rnd, types, result, this.minConst, this.maxConst);
        return result;
    }

    public int determineMaxDepth(Random rnd) {
        return this.maxDepth;
    }

    @Override
    public EncogProgram generate(Random rnd) {
        EncogProgram program = new EncogProgram(this.context);
        ArrayList<ValueType> types = new ArrayList<ValueType>();
        types.add(this.context.getResult().getVariableType());
        program.setRootNode(this.createNode(rnd, program, this.determineMaxDepth(rnd), types));
        return program;
    }

    @Override
    public void generate(Random rnd, Population pop) {
        this.contents.clear();
        pop.getSpecies().clear();
        Species defaultSpecies = pop.createSpecies();
        this.actualThreads = this.score.requireSingleThreaded() ? 1 : (this.threads == 0 ? Runtime.getRuntime().availableProcessors() : this.threads);
        ExecutorService taskExecutor = null;
        taskExecutor = this.threads == 1 ? Executors.newSingleThreadScheduledExecutor() : Executors.newFixedThreadPool(this.actualThreads);
        int i = 0;
        while (i < pop.getPopulationSize()) {
            taskExecutor.execute(new GenerateWorker(this, (PrgPopulation)pop));
            ++i;
        }
        taskExecutor.shutdown();
        try {
            taskExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new GeneticError(e);
        }
        defaultSpecies.setLeader(defaultSpecies.getMembers().get(0));
    }

    public ProgramExtensionTemplate generateRandomOpcode(Random rnd, List<ProgramExtensionTemplate> opcodes) {
        int maxOpCode = opcodes.size();
        if (maxOpCode == 0) {
            return null;
        }
        int tries = 10000;
        ProgramExtensionTemplate result = null;
        while (result == null) {
            int opcode = rnd.nextInt(maxOpCode);
            result = opcodes.get(opcode);
            if (--tries >= 0) continue;
            throw new EACompileError("Could not generate an opcode.  Make sure you have valid opcodes defined.");
        }
        return result;
    }

    public EncogProgramContext getContext() {
        return this.context;
    }

    public double getMaxConst() {
        return this.maxConst;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    @Override
    public int getMaxGenerationErrors() {
        return this.maxGenerationErrors;
    }

    public double getMinConst() {
        return this.minConst;
    }

    public RandomFactory getRandomFactory() {
        return this.randomFactory;
    }

    public CalculateScore getScore() {
        return this.score;
    }

    @Override
    public int getThreadCount() {
        return this.threads;
    }

    public boolean isHasEnum() {
        return this.hasEnum;
    }

    public void setMaxConst(double maxConst) {
        this.maxConst = maxConst;
    }

    @Override
    public void setMaxGenerationErrors(int maxGenerationErrors) {
        this.maxGenerationErrors = maxGenerationErrors;
    }

    public void setMinConst(double minConst) {
        this.minConst = minConst;
    }

    public void setRandomFactory(RandomFactory randomFactory) {
        this.randomFactory = randomFactory;
    }

    public void setScore(CalculateScore score) {
        this.score = score;
    }

    @Override
    public void setThreadCount(int numThreads) {
        this.threads = numThreads;
    }
}

