/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.graph.search;

import java.util.ArrayList;
import java.util.List;
import org.encog.ml.graph.BasicNode;
import org.encog.ml.graph.BasicPath;
import org.encog.ml.graph.search.Prioritizer;

public class FrontierHolder {
    private final List<BasicPath> contents = new ArrayList<BasicPath>();
    private final Prioritizer prioritizer;

    public FrontierHolder(Prioritizer thePrioritizer) {
        this.prioritizer = thePrioritizer;
    }

    public List<BasicPath> getContents() {
        return this.contents;
    }

    public void add(BasicPath path) {
        int i = 0;
        while (i < this.contents.size()) {
            if (this.prioritizer.isHigherPriority(path, this.contents.get(i))) {
                this.contents.add(i, path);
                return;
            }
            ++i;
        }
        this.contents.add(path);
    }

    public BasicPath pop() {
        if (this.contents.size() == 0) {
            return null;
        }
        BasicPath result = this.contents.get(0);
        this.contents.remove(0);
        return result;
    }

    public int size() {
        return this.contents.size();
    }

    public boolean containsDestination(BasicNode node) {
        for (BasicPath path : this.contents) {
            if (!path.getDestinationNode().equals(node)) continue;
            return true;
        }
        return false;
    }
}

