/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.factory.parse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.EncogError;
import org.encog.ml.factory.parse.ArchitectureLayer;
import org.encog.util.SimpleParser;

public final class ArchitectureParse {
    private ArchitectureParse() {
    }

    public static ArchitectureLayer parseLayer(String line, int defaultValue) {
        ArchitectureLayer layer = new ArchitectureLayer();
        String check = line.trim().toUpperCase();
        if (check.endsWith(":B")) {
            check = check.substring(0, check.length() - 2);
            layer.setBias(true);
        }
        try {
            layer.setCount(Integer.parseInt(check));
            if (layer.getCount() < 0) {
                throw new EncogError("Count cannot be less than zero.");
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if ("?".equals(check)) {
            if (defaultValue < 0) {
                throw new EncogError("Default (?) in an invalid location.");
            }
            layer.setCount(defaultValue);
            layer.setUsedDefault(true);
            return layer;
        }
        int startIndex = check.indexOf(40);
        int endIndex = check.lastIndexOf(41);
        if (startIndex == -1) {
            layer.setName(check);
            return layer;
        }
        if (endIndex == -1) {
            throw new EncogError("Illegal parentheses.");
        }
        layer.setName(check.substring(0, startIndex).trim());
        String paramStr = check.substring(startIndex + 1, endIndex);
        Map<String, String> params = ArchitectureParse.parseParams(paramStr);
        layer.getParams().putAll(params);
        return layer;
    }

    public static List<String> parseLayers(String line) {
        ArrayList<String> result = new ArrayList<String>();
        int base = 0;
        boolean done = false;
        do {
            String part;
            int index;
            if ((index = line.indexOf("->", base)) != -1) {
                part = line.substring(base, index).trim();
                base = index + 2;
            } else {
                part = line.substring(base).trim();
                done = true;
            }
            boolean bias = part.endsWith("b");
            if (bias) {
                part = part.substring(0, part.length() - 1);
            }
            result.add(part);
        } while (!done);
        return result;
    }

    private static String parseName(SimpleParser parser) {
        StringBuilder result = new StringBuilder();
        parser.eatWhiteSpace();
        while (parser.isIdentifier()) {
            result.append(parser.readChar());
        }
        return result.toString();
    }

    public static Map<String, String> parseParams(String line) {
        HashMap<String, String> result = new HashMap<String, String>();
        SimpleParser parser = new SimpleParser(line);
        while (!parser.eol()) {
            String name = ArchitectureParse.parseName(parser).toUpperCase();
            parser.eatWhiteSpace();
            if (!parser.lookAhead("=", false)) {
                throw new EncogError("Missing equals(=) operator.");
            }
            parser.advance();
            String value = ArchitectureParse.parseValue(parser);
            result.put(name.toUpperCase(), value);
            if (!parser.parseThroughComma()) break;
        }
        return result;
    }

    private static String parseValue(SimpleParser parser) {
        boolean quoted = false;
        StringBuilder str = new StringBuilder();
        parser.eatWhiteSpace();
        if (parser.peek() == '\"') {
            quoted = true;
            parser.advance();
        }
        while (!parser.eol()) {
            if (parser.peek() == '\"') {
                if (quoted) {
                    parser.advance();
                    if (parser.peek() != '\"') break;
                    str.append(parser.readChar());
                    continue;
                }
                str.append(parser.readChar());
                continue;
            }
            if (!quoted && (parser.isWhiteSpace() || parser.peek() == ',')) break;
            str.append(parser.readChar());
        }
        return str.toString();
    }
}

