/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.factory.method;

import java.util.List;
import org.encog.EncogError;
import org.encog.ml.MLMethod;
import org.encog.ml.factory.parse.ArchitectureLayer;
import org.encog.ml.factory.parse.ArchitectureParse;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.pnn.BasicPNN;
import org.encog.neural.pnn.PNNKernelType;
import org.encog.neural.pnn.PNNOutputMode;
import org.encog.util.ParamsHolder;

public class PNNFactory {
    public static final int MAX_LAYERS = 3;

    public MLMethod create(String architecture, int input, int output) {
        PNNKernelType kernel;
        PNNOutputMode outmodel;
        List<String> layers = ArchitectureParse.parseLayers(architecture);
        if (layers.size() != 3) {
            throw new EncogError("PNN Networks must have exactly three elements, separated by ->.");
        }
        ArchitectureLayer inputLayer = ArchitectureParse.parseLayer(layers.get(0), input);
        ArchitectureLayer pnnLayer = ArchitectureParse.parseLayer(layers.get(1), -1);
        ArchitectureLayer outputLayer = ArchitectureParse.parseLayer(layers.get(2), output);
        int inputCount = inputLayer.getCount();
        int outputCount = outputLayer.getCount();
        if (pnnLayer.getName().equalsIgnoreCase("c")) {
            outmodel = PNNOutputMode.Classification;
        } else if (pnnLayer.getName().equalsIgnoreCase("r")) {
            outmodel = PNNOutputMode.Regression;
        } else if (pnnLayer.getName().equalsIgnoreCase("u")) {
            outmodel = PNNOutputMode.Unsupervised;
        } else {
            throw new NeuralNetworkError("Unknown model: " + pnnLayer.getName());
        }
        ParamsHolder holder = new ParamsHolder(pnnLayer.getParams());
        String kernelStr = holder.getString("KERNEL", false, "gaussian");
        if (kernelStr.equalsIgnoreCase("gaussian")) {
            kernel = PNNKernelType.Gaussian;
        } else if (kernelStr.equalsIgnoreCase("reciprocal")) {
            kernel = PNNKernelType.Reciprocal;
        } else {
            throw new NeuralNetworkError("Unknown kernel: " + kernelStr);
        }
        BasicPNN result = new BasicPNN(kernel, outmodel, inputCount, outputCount);
        return result;
    }
}

