/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.ea.rules;

import java.util.ArrayList;
import java.util.List;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.rules.ConstraintRule;
import org.encog.ml.ea.rules.RewriteRule;
import org.encog.ml.ea.rules.RuleHolder;

public class BasicRuleHolder
implements RuleHolder {
    private final List<RewriteRule> rewriteRules = new ArrayList<RewriteRule>();
    private final List<ConstraintRule> constraintRules = new ArrayList<ConstraintRule>();

    @Override
    public void addRewriteRule(RewriteRule rule) {
        this.rewriteRules.add(rule);
    }

    @Override
    public void rewrite(Genome prg) {
        boolean done = false;
        while (!done) {
            done = true;
            for (RewriteRule rule : this.rewriteRules) {
                if (!rule.rewrite(prg)) continue;
                done = false;
            }
        }
    }

    @Override
    public void addConstraintRule(ConstraintRule rule) {
        this.constraintRules.add(rule);
    }

    @Override
    public boolean isValid(Genome genome) {
        for (ConstraintRule rule : this.constraintRules) {
            if (rule.isValid(genome)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<ConstraintRule> getConstraintRules() {
        return this.constraintRules;
    }

    @Override
    public List<RewriteRule> getRewriteRules() {
        return null;
    }
}

