/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.versatile;

import java.util.Iterator;
import org.encog.EncogError;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.util.EngineArray;

public class MatrixMLDataSet
implements MLDataSet {
    private int calculatedInputSize = -1;
    private int calculatedIdealSize = -1;
    private double[][] data;
    private int[] mask;
    private int lagWindowSize = 0;
    private int leadWindowSize = 0;

    public MatrixMLDataSet() {
    }

    public MatrixMLDataSet(double[][] theData, int theCalculatedInputSize, int theCalculatedIdealSize) {
        this.data = theData;
        this.calculatedInputSize = theCalculatedInputSize;
        this.calculatedIdealSize = theCalculatedIdealSize;
    }

    public MatrixMLDataSet(double[][] theData, int inputCount, int idealCount, int[] theMask) {
        this.data = theData;
        this.calculatedInputSize = inputCount;
        this.calculatedIdealSize = idealCount;
        this.mask = theMask;
    }

    public MatrixMLDataSet(MatrixMLDataSet data, int[] mask) {
        this.data = data.getData();
        this.calculatedInputSize = data.getCalculatedInputSize();
        this.calculatedIdealSize = data.getCalculatedIdealSize();
        this.mask = mask;
    }

    public int[] getMask() {
        return this.mask;
    }

    @Override
    public Iterator<MLDataPair> iterator() {
        return new MatrixMLDataSetIterator();
    }

    @Override
    public int getIdealSize() {
        return this.calculatedIdealSize * Math.min(this.leadWindowSize, 1);
    }

    @Override
    public int getInputSize() {
        return this.calculatedInputSize * this.lagWindowSize;
    }

    @Override
    public boolean isSupervised() {
        return this.getIdealSize() == 0;
    }

    @Override
    public long getRecordCount() {
        if (this.data == null) {
            throw new EncogError("You must normalize the dataset before using it.");
        }
        if (this.mask == null) {
            return this.data.length - (this.lagWindowSize + this.leadWindowSize);
        }
        return this.mask.length - (this.lagWindowSize + this.leadWindowSize);
    }

    private int calculateLagCount() {
        return this.lagWindowSize <= 0 ? 1 : this.lagWindowSize + 1;
    }

    private int calculateLeadCount() {
        return this.leadWindowSize <= 1 ? 1 : this.leadWindowSize;
    }

    @Override
    public void getRecord(long index, MLDataPair pair) {
        if (this.data == null) {
            throw new EncogError("You must normalize the dataset before using it.");
        }
        int inputSize = this.calculateLagCount();
        int i = 0;
        while (i < inputSize) {
            double[] dataRow = this.lookupDataRow((int)(index + (long)i));
            EngineArray.arrayCopy(dataRow, 0, pair.getInput().getData(), i * this.calculatedInputSize, this.calculatedInputSize);
            ++i;
        }
        int outputStart = this.leadWindowSize > 0 ? 1 : 0;
        int outputSize = this.calculateLeadCount();
        int i2 = 0;
        while (i2 < outputSize) {
            double[] dataRow = this.lookupDataRow((int)(index + (long)i2 + (long)outputStart));
            EngineArray.arrayCopy(dataRow, this.calculatedInputSize, pair.getIdealArray(), i2 * this.calculatedIdealSize, this.calculatedIdealSize);
            ++i2;
        }
    }

    private double[] lookupDataRow(int index) {
        if (this.mask != null) {
            return this.data[this.mask[index]];
        }
        return this.data[index];
    }

    @Override
    public MLDataSet openAdditional() {
        MatrixMLDataSet result = new MatrixMLDataSet(this.data, this.calculatedInputSize, this.calculatedIdealSize, this.mask);
        result.setLagWindowSize(this.getLagWindowSize());
        result.setLeadWindowSize(this.getLeadWindowSize());
        return result;
    }

    @Override
    public void add(MLData data1) {
    }

    @Override
    public void add(MLData inputData, MLData idealData) {
    }

    @Override
    public void add(MLDataPair inputData) {
    }

    @Override
    public void close() {
    }

    @Override
    public int size() {
        return (int)this.getRecordCount();
    }

    @Override
    public MLDataPair get(int index) {
        if (index > this.size()) {
            return null;
        }
        BasicMLData input = new BasicMLData(this.calculatedInputSize * this.calculateLagCount());
        BasicMLData ideal = new BasicMLData(this.calculatedIdealSize * this.calculateLeadCount());
        BasicMLDataPair pair = new BasicMLDataPair(input, ideal);
        this.getRecord(index, pair);
        return pair;
    }

    public int getCalculatedInputSize() {
        return this.calculatedInputSize;
    }

    public void setCalculatedInputSize(int calculatedInputSize) {
        this.calculatedInputSize = calculatedInputSize;
    }

    public int getCalculatedIdealSize() {
        return this.calculatedIdealSize;
    }

    public void setCalculatedIdealSize(int calculatedIdealSize) {
        this.calculatedIdealSize = calculatedIdealSize;
    }

    public double[][] getData() {
        return this.data;
    }

    public void setData(double[][] data) {
        this.data = data;
    }

    public int getLagWindowSize() {
        return this.lagWindowSize;
    }

    public void setLagWindowSize(int lagWindowSize) {
        this.lagWindowSize = lagWindowSize;
    }

    public int getLeadWindowSize() {
        return this.leadWindowSize;
    }

    public void setLeadWindowSize(int leadWindowSize) {
        this.leadWindowSize = leadWindowSize;
    }

    public class MatrixMLDataSetIterator
    implements Iterator<MLDataPair> {
        private int currentIndex = 0;

        @Override
        public final boolean hasNext() {
            return this.currentIndex < MatrixMLDataSet.this.size();
        }

        @Override
        public final MLDataPair next() {
            if (!this.hasNext()) {
                return null;
            }
            return MatrixMLDataSet.this.get(this.currentIndex++);
        }

        @Override
        public final void remove() {
            throw new EncogError("Called remove, unsupported operation.");
        }
    }
}

