/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.buffer;

import java.util.Iterator;
import org.encog.ml.data.MLDataError;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.data.buffer.BufferedMLDataSet;

public class BufferedDataSetIterator
implements Iterator<MLDataPair> {
    private final BufferedMLDataSet data;
    private int current;

    public BufferedDataSetIterator(BufferedMLDataSet theData) {
        this.data = theData;
        this.current = 0;
    }

    @Override
    public boolean hasNext() {
        return (long)this.current < this.data.getRecordCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MLDataPair next() {
        BufferedMLDataSet bufferedMLDataSet = this.data;
        synchronized (bufferedMLDataSet) {
            block4: {
                if (this.hasNext()) break block4;
                return null;
            }
            MLDataPair pair = BasicMLDataPair.createPair(this.data.getInputSize(), this.data.getIdealSize());
            this.data.getRecord(this.current++, pair);
            return pair;
        }
    }

    @Override
    public void remove() {
        throw new MLDataError("Remove is not supported.");
    }
}

