/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.bayesian;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.encog.ml.bayesian.BayesianError;
import org.encog.ml.bayesian.BayesianEvent;
import org.encog.ml.bayesian.BayesianNetwork;
import org.encog.ml.bayesian.query.BasicQuery;
import org.encog.ml.bayesian.query.enumerate.EnumerationQuery;
import org.encog.ml.bayesian.query.sample.SamplingQuery;
import org.encog.ml.bayesian.table.TableLine;
import org.encog.persist.EncogFileSection;
import org.encog.persist.EncogPersistor;
import org.encog.persist.EncogReadHelper;
import org.encog.persist.EncogWriteHelper;

public class PersistBayes
implements EncogPersistor {
    @Override
    public final int getFileVersion() {
        return 1;
    }

    @Override
    public final Object read(InputStream is) {
        EncogFileSection section;
        BayesianNetwork result = new BayesianNetwork();
        EncogReadHelper in = new EncogReadHelper(is);
        String queryType = "";
        String queryStr = "";
        String contentsStr = "";
        while ((section = in.readNextSection()) != null) {
            Map<String, String> params;
            if (section.getSectionName().equals("BAYES-NETWORK") && section.getSubSectionName().equals("BAYES-PARAM")) {
                params = section.parseParams();
                queryType = params.get("queryType");
                queryStr = params.get("query");
                contentsStr = params.get("contents");
            }
            if (section.getSectionName().equals("BAYES-NETWORK") && section.getSubSectionName().equals("BAYES-TABLE")) {
                result.setContents(contentsStr);
                for (String line : section.getLines()) {
                    result.defineRelationship(line);
                }
                result.finalizeStructure();
                for (String line : section.getLines()) {
                    result.defineProbability(line);
                }
            }
            if (!section.getSectionName().equals("BAYES-NETWORK") || !section.getSubSectionName().equals("BAYES-PROPERTIES")) continue;
            params = section.parseParams();
            result.getProperties().putAll(params);
        }
        if (queryType.length() > 0) {
            BasicQuery query = null;
            query = queryType.equals("EnumerationQuery") ? new EnumerationQuery(result) : new SamplingQuery(result);
            if (query != null && queryStr.length() > 0) {
                result.setQuery(query);
                result.defineClassificationStructure(queryStr);
            }
        }
        return result;
    }

    @Override
    public final void save(OutputStream os, Object obj) {
        EncogWriteHelper out = new EncogWriteHelper(os);
        BayesianNetwork b = (BayesianNetwork)obj;
        out.addSection("BAYES-NETWORK");
        out.addSubSection("BAYES-PARAM");
        String queryType = "";
        String queryStr = b.getClassificationStructure();
        if (b.getQuery() != null) {
            queryType = b.getQuery().getClass().getSimpleName();
        }
        out.writeProperty("queryType", queryType);
        out.writeProperty("query", queryStr);
        out.writeProperty("contents", b.getContents());
        out.addSubSection("BAYES-PROPERTIES");
        out.addProperties(b.getProperties());
        out.addSubSection("BAYES-TABLE");
        for (BayesianEvent event : b.getEvents()) {
            for (TableLine line : event.getTable().getLines()) {
                if (line == null) continue;
                StringBuilder str = new StringBuilder();
                str.append("P(");
                str.append(BayesianEvent.formatEventName(event, line.getResult()));
                if (event.getParents().size() > 0) {
                    str.append("|");
                }
                int index = 0;
                boolean first = true;
                for (BayesianEvent parentEvent : event.getParents()) {
                    if (!first) {
                        str.append(",");
                    }
                    first = false;
                    int arg = line.getArguments()[index++];
                    if (parentEvent.isBoolean()) {
                        if (arg == 0) {
                            str.append("+");
                        } else {
                            str.append("-");
                        }
                    }
                    str.append(parentEvent.getLabel());
                    if (parentEvent.isBoolean()) continue;
                    str.append("=");
                    if (arg >= parentEvent.getChoices().size()) {
                        throw new BayesianError("Argument value " + arg + " is out of range for event " + parentEvent.toString());
                    }
                    str.append(parentEvent.getChoice(arg));
                }
                str.append(")=");
                str.append(line.getProbability());
                str.append("\n");
                out.write(str.toString());
            }
        }
        out.flush();
    }

    @Override
    public String getPersistClassString() {
        return "BayesianNetwork";
    }
}

