/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.randomize;

import java.io.Serializable;
import java.util.Random;
import org.encog.EncogError;
import org.encog.util.EngineArray;

public class RandomChoice
implements Serializable {
    private final double[] probabilities;

    public RandomChoice(double[] theProbabilities) {
        block5: {
            double total;
            block4: {
                this.probabilities = EngineArray.arrayCopy(theProbabilities);
                total = 0.0;
                int i = 0;
                while (i < this.probabilities.length) {
                    total += this.probabilities[i];
                    ++i;
                }
                if (total != 0.0) break block4;
                double prob = 1.0 / (double)this.probabilities.length;
                int i2 = 0;
                while (i2 < this.probabilities.length) {
                    this.probabilities[i2] = prob;
                    ++i2;
                }
                break block5;
            }
            double total2 = 0.0;
            double factor = 1.0 / total;
            int i = 0;
            while (i < this.probabilities.length) {
                this.probabilities[i] = this.probabilities[i] * factor;
                total2 += this.probabilities[i];
                ++i;
            }
            if (!(Math.abs(1.0 - total2) > 0.02)) break block5;
            double prob = 1.0 / (double)this.probabilities.length;
            int i3 = 0;
            while (i3 < this.probabilities.length) {
                this.probabilities[i3] = prob;
                ++i3;
            }
        }
    }

    public int generate(Random theGenerator) {
        double r = theGenerator.nextDouble();
        double sum = 0.0;
        int i = 0;
        while (i < this.probabilities.length) {
            if (r < (sum += this.probabilities[i])) {
                return i;
            }
            ++i;
        }
        i = 0;
        while (i < this.probabilities.length) {
            if (this.probabilities[i] != 0.0) {
                return i;
            }
            ++i;
        }
        throw new EncogError("Invalid probabilities.");
    }

    public int generate(Random theGenerator, int skip) {
        double totalProb = 1.0 - this.probabilities[skip];
        double throwValue = theGenerator.nextDouble() * totalProb;
        double accumulator = 0.0;
        int i = 0;
        while (i < skip) {
            if ((accumulator += this.probabilities[i]) > throwValue) {
                return i;
            }
            ++i;
        }
        i = skip + 1;
        while (i < this.probabilities.length) {
            if ((accumulator += this.probabilities[i]) > throwValue) {
                return i;
            }
            ++i;
        }
        i = 0;
        while (i < skip) {
            if (this.probabilities[i] != 0.0) {
                return i;
            }
            ++i;
        }
        i = skip + 1;
        while (i < this.probabilities.length) {
            if (this.probabilities[i] != 0.0) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

