/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.network.activation.ActivationFunction;

public class ActivationSteepenedSigmoid
implements ActivationFunction {
    private static final long serialVersionUID = 1L;
    private final double[] params = new double[0];

    @Override
    public final void activationFunction(double[] x, int start, int size) {
        int i = start;
        while (i < start + size) {
            x[i] = 1.0 / (1.0 + Math.exp(-4.9 * x[i]));
            ++i;
        }
    }

    @Override
    public final ActivationFunction clone() {
        return new ActivationSteepenedSigmoid();
    }

    @Override
    public final double derivativeFunction(double b, double a) {
        double s = Math.exp(-4.9 * a);
        return Math.pow(s * 4.9 / (1.0 + s), 2.0);
    }

    @Override
    public final String[] getParamNames() {
        String[] result = new String[]{};
        return result;
    }

    @Override
    public final double[] getParams() {
        return this.params;
    }

    @Override
    public final boolean hasDerivative() {
        return true;
    }

    @Override
    public final void setParam(int index, double value) {
        this.params[index] = value;
    }

    @Override
    public String getFactoryCode() {
        return null;
    }

    @Override
    public String getLabel() {
        return "steepenedsigmoid";
    }
}

