/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.mathutil.BoundMath;
import org.encog.util.obj.ActivationUtil;

public class ActivationSoftMax
implements ActivationFunction {
    private static final long serialVersionUID = -960489243250457611L;
    private final double[] params = new double[0];

    @Override
    public final void activationFunction(double[] x, int start, int size) {
        double sum = 0.0;
        int i = start;
        while (i < start + size) {
            x[i] = BoundMath.exp(x[i]);
            sum += x[i];
            ++i;
        }
        if (Double.isNaN(sum) || sum < 1.0E-13) {
            i = start;
            while (i < start + size) {
                x[i] = 1.0 / (double)size;
                ++i;
            }
        } else {
            i = start;
            while (i < start + size) {
                x[i] = x[i] / sum;
                ++i;
            }
        }
    }

    @Override
    public final ActivationFunction clone() {
        return new ActivationSoftMax();
    }

    @Override
    public final double derivativeFunction(double b, double a) {
        return 1.0;
    }

    @Override
    public final String[] getParamNames() {
        String[] result = new String[]{};
        return result;
    }

    @Override
    public final double[] getParams() {
        return this.params;
    }

    @Override
    public final boolean hasDerivative() {
        return true;
    }

    @Override
    public final void setParam(int index, double value) {
        this.params[index] = value;
    }

    @Override
    public String getFactoryCode() {
        return ActivationUtil.generateActivationFactory("softmax", this);
    }

    @Override
    public String getLabel() {
        return "softmax";
    }
}

