/*
 * Decompiled with CFR 0.152.
 */
package org.encog.bot.rss;

import java.util.Date;
import org.encog.bot.rss.RSS;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RSSItem {
    private String title;
    private String link;
    private String description;
    private Date date;

    public final Date getDate() {
        return this.date;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getLink() {
        return this.link;
    }

    public final String getTitle() {
        return this.title;
    }

    public final void load(Node node) {
        NodeList nl = node.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            String str;
            Node n = nl.item(i);
            String name = n.getNodeName();
            if (name.equalsIgnoreCase("title")) {
                this.title = RSS.getXMLText(n);
            } else if (name.equalsIgnoreCase("link")) {
                this.link = RSS.getXMLText(n);
            } else if (name.equalsIgnoreCase("description")) {
                this.description = RSS.getXMLText(n);
            } else if (name.equalsIgnoreCase("pubDate") && (str = RSS.getXMLText(n)) != null) {
                this.date = RSS.parseDate(str);
            }
            ++i;
        }
    }

    public final void setDate(Date theDate) {
        this.date = theDate;
    }

    public final void setDescription(String theDescription) {
        this.description = theDescription;
    }

    public final void setLink(String theLink) {
        this.link = theLink;
    }

    public final void setTitle(String theTitle) {
        this.title = theTitle;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        builder.append("title=\"");
        builder.append(this.title);
        builder.append("\",link=\"");
        builder.append(this.link);
        builder.append("\",date=\"");
        builder.append(this.date);
        builder.append("\"]");
        return builder.toString();
    }
}

