/*
 * Decompiled with CFR 0.152.
 */
package org.encog.bot.rss;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.encog.bot.BotError;
import org.encog.bot.rss.RSSItem;
import org.encog.util.logging.EncogLogging;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RSS {
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final List<RSSItem> items = new ArrayList<RSSItem>();

    public static String getXMLText(Node n) {
        NodeList list = n.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node n2 = list.item(i);
            if (n2.getNodeType() == 3) {
                return n2.getNodeValue();
            }
            ++i;
        }
        return null;
    }

    public static Date parseDate(String datestr) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z");
            Date date = formatter.parse(datestr);
            return date;
        }
        catch (Exception e) {
            return null;
        }
    }

    public final Map<String, String> getAttributes() {
        return this.attributes;
    }

    public final List<RSSItem> getItems() {
        return this.items;
    }

    public final void load(URL url) {
        this.load(url, -1);
    }

    public final void load(URL url, int timeout) {
        try {
            EncogLogging.log(0, "Loading RSS from:" + url);
            URLConnection http = url.openConnection();
            if (timeout > 0) {
                http.setConnectTimeout(timeout);
            }
            http.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Win64; x64; Trident/4.0)");
            InputStream is = http.getInputStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document d = factory.newDocumentBuilder().parse(is);
            Element e = d.getDocumentElement();
            NodeList nl = e.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node node = nl.item(i);
                String nodename = node.getNodeName();
                if (nodename.equalsIgnoreCase("channel")) {
                    this.loadChannel(node);
                } else if (nodename.equalsIgnoreCase("item")) {
                    this.loadItem(node);
                }
                ++i;
            }
        }
        catch (IOException e) {
            EncogLogging.log(e);
            throw new BotError(e);
        }
        catch (SAXException e) {
            EncogLogging.log(e);
            throw new BotError(e);
        }
        catch (ParserConfigurationException e) {
            EncogLogging.log(e);
            throw new BotError(e);
        }
    }

    private void loadChannel(Node channel) {
        NodeList nl = channel.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            String nodename = node.getNodeName();
            if (nodename.equalsIgnoreCase("item")) {
                this.loadItem(node);
            } else if (node.getNodeType() != 3) {
                this.attributes.put(nodename, RSS.getXMLText(node));
            }
            ++i;
        }
    }

    private void loadItem(Node item) {
        RSSItem rssItem = new RSSItem();
        rssItem.load(item);
        this.items.add(rssItem);
        EncogLogging.log(0, "Loaded RSS item:" + rssItem);
    }

    public final String toString() {
        StringBuilder str = new StringBuilder();
        Set<String> set = this.attributes.keySet();
        for (String string : set) {
            str.append(string);
            str.append('=');
            str.append(this.attributes.get(string));
            str.append('\n');
        }
        str.append("Items:\n");
        for (RSSItem rSSItem : this.items) {
            str.append(rSSItem.toString());
            str.append('\n');
        }
        return str.toString();
    }
}

