/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.commands;

import java.io.File;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.commands.Cmd;
import org.encog.app.analyst.csv.segregate.SegregateCSV;
import org.encog.app.analyst.csv.segregate.SegregateTargetPercent;
import org.encog.app.analyst.script.segregate.AnalystSegregateTarget;
import org.encog.app.analyst.util.AnalystReportBridge;
import org.encog.util.Format;
import org.encog.util.csv.CSVFormat;
import org.encog.util.logging.EncogLogging;

public class CmdSegregate
extends Cmd {
    public static final String COMMAND_NAME = "SEGREGATE";

    public CmdSegregate(EncogAnalyst analyst) {
        super(analyst);
    }

    @Override
    public boolean executeCommand(String args) {
        String sourceID = this.getProp().getPropertyString("SEGREGATE:CONFIG_sourceFile");
        File sourceFile = this.getScript().resolveFilename(sourceID);
        EncogLogging.log(0, "Beginning segregate");
        EncogLogging.log(0, "source file:" + sourceID);
        CSVFormat format = this.getScript().determineFormat();
        boolean headers = this.getScript().expectInputHeaders(sourceID);
        SegregateCSV seg = new SegregateCSV();
        seg.setScript(this.getScript());
        this.getAnalyst().setCurrentQuantTask(seg);
        AnalystSegregateTarget[] analystSegregateTargetArray = this.getScript().getSegregate().getSegregateTargets();
        int n = analystSegregateTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnalystSegregateTarget target = analystSegregateTargetArray[n2];
            File filename = this.getScript().resolveFilename(target.getFile());
            seg.getTargets().add(new SegregateTargetPercent(filename, target.getPercent()));
            this.getScript().markGenerated(target.getFile());
            EncogLogging.log(0, "target file:" + target.getFile() + ", Percent: " + Format.formatPercent(target.getPercent()));
            ++n2;
        }
        seg.setReport(new AnalystReportBridge(this.getAnalyst()));
        seg.analyze(sourceFile, headers, format);
        seg.process();
        this.getAnalyst().setCurrentQuantTask(null);
        return seg.shouldStop();
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }
}

