/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.commands;

import java.io.File;
import java.util.Random;
import org.encog.app.analyst.AnalystError;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.commands.Cmd;
import org.encog.app.analyst.script.DataField;
import org.encog.app.analyst.script.ml.ScriptOpcode;
import org.encog.app.analyst.script.normalize.AnalystField;
import org.encog.ml.MLMethod;
import org.encog.ml.bayesian.BayesianNetwork;
import org.encog.ml.data.buffer.EncogEGBFile;
import org.encog.ml.factory.MLMethodFactory;
import org.encog.ml.prg.VariableMapping;
import org.encog.ml.prg.expvalue.ValueType;
import org.encog.ml.prg.extension.EncogOpcodeRegistry;
import org.encog.ml.prg.extension.ProgramExtensionTemplate;
import org.encog.ml.prg.generator.RampedHalfAndHalf;
import org.encog.ml.prg.train.PrgPopulation;
import org.encog.persist.EncogDirectoryPersistence;
import org.encog.util.logging.EncogLogging;

public class CmdCreate
extends Cmd {
    public static final String COMMAND_NAME = "CREATE";

    public CmdCreate(EncogAnalyst theAnalyst) {
        super(theAnalyst);
    }

    @Override
    public boolean executeCommand(String args) {
        String trainingID = this.getProp().getPropertyString("ML:CONFIG_trainingFile");
        String resourceID = this.getProp().getPropertyString("ML:CONFIG_machineLearningFile");
        File trainingFile = this.getScript().resolveFilename(trainingID);
        File resourceFile = this.getScript().resolveFilename(resourceID);
        String type = this.getProp().getPropertyString("ML:CONFIG_type");
        String arch = this.getProp().getPropertyString("ML:CONFIG_architecture");
        EncogLogging.log(0, "Beginning create");
        EncogLogging.log(0, "training file:" + trainingID);
        EncogLogging.log(0, "resource file:" + resourceID);
        EncogLogging.log(0, "type:" + type);
        EncogLogging.log(0, "arch:" + arch);
        EncogEGBFile egb = new EncogEGBFile(trainingFile);
        egb.open();
        int input = egb.getInputCount();
        int ideal = egb.getIdealCount();
        egb.close();
        MLMethodFactory factory = new MLMethodFactory();
        MLMethod obj = factory.create(type, arch, input, ideal);
        if (obj instanceof BayesianNetwork) {
            String query = this.getProp().getPropertyString("ML:CONFIG_query");
            ((BayesianNetwork)obj).defineClassificationStructure(query);
        } else if (obj instanceof PrgPopulation) {
            this.handlePrgPopulation((PrgPopulation)obj);
        }
        EncogDirectoryPersistence.saveObject(resourceFile, (Object)obj);
        return false;
    }

    private void handlePrgPopulation(PrgPopulation pop) {
        int classType = 0;
        pop.getContext().clearDefinedVariables();
        for (AnalystField field : this.getScript().getNormalize().getNormalizedFields()) {
            VariableMapping mapping;
            DataField df = this.getScript().findDataField(field.getName());
            String varName = field.getName();
            switch (field.getAction()) {
                case Ignore: {
                    mapping = null;
                    break;
                }
                case PassThrough: {
                    if (df.isInteger()) {
                        mapping = new VariableMapping(varName, ValueType.intType);
                        break;
                    }
                    if (df.isReal()) {
                        mapping = new VariableMapping(varName, ValueType.floatingType);
                        break;
                    }
                    mapping = new VariableMapping(varName, ValueType.stringType);
                    break;
                }
                case Normalize: 
                case OneOf: 
                case Equilateral: {
                    mapping = new VariableMapping(varName, ValueType.floatingType);
                    break;
                }
                case SingleField: {
                    if (df.isClass()) {
                        mapping = new VariableMapping(varName, ValueType.enumType, classType++, df.getClassMembers().size());
                        break;
                    }
                    if (df.isInteger()) {
                        mapping = new VariableMapping(varName, ValueType.intType);
                        break;
                    }
                    mapping = new VariableMapping(varName, ValueType.floatingType);
                    break;
                }
                default: {
                    throw new AnalystError("Unknown normalization action: " + field.getAction().toString());
                }
            }
            if (field.isOutput()) {
                pop.getContext().setResult(mapping);
                continue;
            }
            pop.getContext().defineVariable(mapping);
        }
        if (this.getScript().getOpcodes().size() > 0) {
            for (ScriptOpcode op : this.getScript().getOpcodes()) {
                ProgramExtensionTemplate temp = EncogOpcodeRegistry.INSTANCE.findOpcode(op.getName(), op.getArgCount());
                pop.getContext().getFunctions().addExtension(temp);
            }
        }
        RampedHalfAndHalf generate = new RampedHalfAndHalf(pop.getContext(), 1, 6);
        generate.generate(new Random(), pop);
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }
}

