/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractIntegerDistribution;
import org.apache.commons.math.distribution.BinomialDistribution;
import org.apache.commons.math.distribution.SaddlePointExpansion;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.special.Beta;
import org.apache.commons.math.util.FastMath;

public class BinomialDistributionImpl
extends AbstractIntegerDistribution
implements BinomialDistribution,
Serializable {
    private static final long serialVersionUID = 6751309484392813623L;
    private int numberOfTrials;
    private double probabilityOfSuccess;

    public BinomialDistributionImpl(int trials, double p) {
        this.setNumberOfTrialsInternal(trials);
        this.setProbabilityOfSuccessInternal(p);
    }

    @Override
    public int getNumberOfTrials() {
        return this.numberOfTrials;
    }

    @Override
    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    @Deprecated
    public void setNumberOfTrials(int trials) {
        this.setNumberOfTrialsInternal(trials);
    }

    private void setNumberOfTrialsInternal(int trials) {
        if (trials < 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NEGATIVE_NUMBER_OF_TRIALS, trials);
        }
        this.numberOfTrials = trials;
    }

    @Override
    @Deprecated
    public void setProbabilityOfSuccess(double p) {
        this.setProbabilityOfSuccessInternal(p);
    }

    private void setProbabilityOfSuccessInternal(double p) {
        if (p < 0.0 || p > 1.0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.OUT_OF_RANGE_SIMPLE, p, 0.0, 1.0);
        }
        this.probabilityOfSuccess = p;
    }

    @Override
    protected int getDomainLowerBound(double p) {
        return -1;
    }

    @Override
    protected int getDomainUpperBound(double p) {
        return this.numberOfTrials;
    }

    @Override
    public double cumulativeProbability(int x) throws MathException {
        double ret = x < 0 ? 0.0 : (x >= this.numberOfTrials ? 1.0 : 1.0 - Beta.regularizedBeta(this.getProbabilityOfSuccess(), (double)x + 1.0, this.numberOfTrials - x));
        return ret;
    }

    @Override
    public double probability(int x) {
        double ret = x < 0 || x > this.numberOfTrials ? 0.0 : FastMath.exp(SaddlePointExpansion.logBinomialProbability(x, this.numberOfTrials, this.probabilityOfSuccess, 1.0 - this.probabilityOfSuccess));
        return ret;
    }

    @Override
    public int inverseCumulativeProbability(double p) throws MathException {
        if (p == 0.0) {
            return -1;
        }
        if (p == 1.0) {
            return Integer.MAX_VALUE;
        }
        return super.inverseCumulativeProbability(p);
    }

    public int getSupportLowerBound() {
        return 0;
    }

    public int getSupportUpperBound() {
        return this.getNumberOfTrials();
    }

    public double getNumericalMean() {
        return (double)this.getNumberOfTrials() * this.getProbabilityOfSuccess();
    }

    public double getNumericalVariance() {
        double p = this.getProbabilityOfSuccess();
        return (double)this.getNumberOfTrials() * p * (1.0 - p);
    }
}

