/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.StringTokenizer;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IPersistentRepresentation;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.UnsupportedRepresentationException;
import org.jgap.impl.NumberGene;
import org.jgap.impl.StockRandomGenerator;

public class MutipleIntegerGene
extends NumberGene
implements IPersistentRepresentation {
    private static final String CVS_REVISION = "$Revision: 1.2 $";
    private int m_upperBounds;
    private int m_lowerBounds;
    private int m_significance;
    protected static final long INTEGER_RANGE = 0xFFFFFFFFL;

    public MutipleIntegerGene() throws InvalidConfigurationException {
        this(Genotype.getStaticConfiguration());
    }

    public MutipleIntegerGene(Configuration a_config) throws InvalidConfigurationException {
        this(a_config, -1073741823, 0x3FFFFFFF, 1);
    }

    public MutipleIntegerGene(Configuration a_config, int a_lowerBound, int a_upperBound, int a_significance) throws InvalidConfigurationException {
        super(a_config);
        int test;
        this.m_lowerBounds = a_lowerBound;
        this.m_upperBounds = a_upperBound;
        this.m_significance = a_significance;
        if (this.m_upperBounds - this.m_lowerBounds < this.m_significance && ((test = this.round((this.m_upperBounds + this.m_lowerBounds) / 2, this.m_significance)) < this.m_lowerBounds || test > this.m_upperBounds)) {
            throw new IllegalArgumentException("Lower and upper bound do not match significance!");
        }
    }

    @Override
    protected Gene newGeneInternal() {
        try {
            MutipleIntegerGene result = new MutipleIntegerGene(this.getConfiguration(), this.m_lowerBounds, this.m_upperBounds, this.m_significance);
            return result;
        }
        catch (InvalidConfigurationException iex) {
            throw new IllegalStateException(iex.getMessage());
        }
    }

    @Override
    public String getPersistentRepresentation() {
        String s = this.getInternalValue() == null ? "null" : this.getInternalValue().toString();
        return s + ":" + this.m_lowerBounds + ":" + this.m_upperBounds + ":" + this.m_significance;
    }

    @Override
    public void setValueFromPersistentRepresentation(String a_representation) throws UnsupportedRepresentationException {
        if (a_representation != null) {
            StringTokenizer tokenizer = new StringTokenizer(a_representation, ":");
            if (tokenizer.countTokens() != 4) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation  is not recognized: it does not contain three tokens: " + a_representation);
            }
            String valueRepresentation = tokenizer.nextToken();
            String lowerBoundRepresentation = tokenizer.nextToken();
            String upperBoundRepresentation = tokenizer.nextToken();
            String significanceRepresentation = tokenizer.nextToken();
            if (valueRepresentation.equals("null")) {
                this.setAllele(null);
            } else {
                try {
                    this.setAllele(new Integer(Integer.parseInt(valueRepresentation)));
                }
                catch (NumberFormatException e) {
                    throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 1 does not appear to be an integer value.");
                }
            }
            try {
                this.m_lowerBounds = Integer.parseInt(lowerBoundRepresentation);
            }
            catch (NumberFormatException e) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 2 does not appear to be an integer value.");
            }
            try {
                this.m_upperBounds = Integer.parseInt(upperBoundRepresentation);
            }
            catch (NumberFormatException e) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 3 does not appear to be an integer value.");
            }
            try {
                this.m_significance = Integer.parseInt(significanceRepresentation);
            }
            catch (NumberFormatException e) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 3 does not appear to be an integer value.");
            }
        }
    }

    @Override
    public void setToRandomValue(RandomGenerator a_numberGenerator) {
        this.setAllele(new Integer(this.getRandomValue(a_numberGenerator)));
    }

    private Integer getRandomValue(RandomGenerator a_numberGenerator) {
        double randomValue = (double)((long)this.m_upperBounds - (long)this.m_lowerBounds) * a_numberGenerator.nextDouble() + (double)this.m_lowerBounds;
        return this.round(randomValue, this.m_significance);
    }

    private int round(double value, Integer factor) {
        if (value % (double)factor.intValue() == 0.0) {
            return (int)value;
        }
        int floor = (int)(value / (double)factor.intValue()) * factor;
        int ceiling = floor + factor;
        if ((double)ceiling - value <= value - (double)floor && ceiling <= this.m_upperBounds) {
            return ceiling;
        }
        if (floor >= this.m_lowerBounds) {
            return floor;
        }
        return ceiling;
    }

    @Override
    protected int compareToNative(Object a_o1, Object a_o2) {
        return ((Integer)a_o1).compareTo((Integer)a_o2);
    }

    @Override
    protected void mapValueToWithinBounds() {
        Integer i_value;
        if (this.getAllele() != null && ((i_value = (Integer)this.getAllele()) > this.m_upperBounds || i_value < this.m_lowerBounds)) {
            RandomGenerator rn = this.getConfiguration() != null ? this.getConfiguration().getRandomGenerator() : new StockRandomGenerator();
            if (this.m_upperBounds == this.m_lowerBounds) {
                this.setAllele(new Integer(this.m_lowerBounds));
            } else {
                this.setToRandomValue(rn);
            }
        }
    }

    @Override
    public void applyMutation(int a_index, double a_percentage) {
        double range = (double)((long)this.m_upperBounds - (long)this.m_lowerBounds) * a_percentage;
        if (this.getAllele() == null) {
            this.setAllele(new Integer((int)range + this.m_lowerBounds));
        } else {
            Integer i_value = (Integer)this.getAllele();
            int newValue = (int)Math.round((double)i_value.intValue() + range);
            newValue = this.round(newValue, this.m_significance);
            this.setAllele(new Integer(newValue));
        }
    }

    @Override
    public int hashCode() {
        if (this.getInternalValue() == null) {
            return -1;
        }
        return super.hashCode();
    }

    @Override
    public String toString() {
        String s = "IntegerGene(" + this.m_lowerBounds + "," + this.m_upperBounds + "," + this.m_significance + ")" + "=";
        s = this.getInternalValue() == null ? s + "null" : s + this.getInternalValue().toString();
        return s;
    }

    public int getLowerBounds() {
        return this.m_lowerBounds;
    }

    public int getUpperBounds() {
        return this.m_upperBounds;
    }

    public int getSignificance() {
        return this.m_significance;
    }
}

