/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.List;
import java.util.Vector;
import org.jgap.BaseGeneticOperator;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.ICompositeGene;
import org.jgap.IGeneticOperatorConstraint;
import org.jgap.IUniversalRateCalculator;
import org.jgap.InvalidConfigurationException;
import org.jgap.Population;
import org.jgap.RandomGenerator;

public class CrossoverOperator
extends BaseGeneticOperator
implements Comparable {
    private static final String CVS_REVISION = "$Revision: 1.48 $";
    private int m_crossoverRate;
    private double m_crossoverRatePercent;
    private IUniversalRateCalculator m_crossoverRateCalc;
    private boolean m_allowFullCrossOver;
    private boolean m_xoverNewAge;

    public CrossoverOperator() throws InvalidConfigurationException {
        super(Genotype.getStaticConfiguration());
        this.init();
    }

    public CrossoverOperator(Configuration a_configuration) throws InvalidConfigurationException {
        super(a_configuration);
        this.init();
    }

    protected void init() {
        this.m_crossoverRate = 6;
        this.m_crossoverRatePercent = -1.0;
        this.setCrossoverRateCalc(null);
        this.setAllowFullCrossOver(true);
        this.setXoverNewAge(true);
    }

    public CrossoverOperator(Configuration a_configuration, IUniversalRateCalculator a_crossoverRateCalculator) throws InvalidConfigurationException {
        this(a_configuration, a_crossoverRateCalculator, true);
    }

    public CrossoverOperator(Configuration a_configuration, IUniversalRateCalculator a_crossoverRateCalculator, boolean a_allowFullCrossOver) throws InvalidConfigurationException {
        super(a_configuration);
        this.setCrossoverRateCalc(a_crossoverRateCalculator);
        this.setAllowFullCrossOver(a_allowFullCrossOver);
    }

    public CrossoverOperator(Configuration a_configuration, int a_desiredCrossoverRate) throws InvalidConfigurationException {
        this(a_configuration, a_desiredCrossoverRate, true);
    }

    public CrossoverOperator(Configuration a_configuration, int a_desiredCrossoverRate, boolean a_allowFullCrossOver) throws InvalidConfigurationException {
        this(a_configuration, a_desiredCrossoverRate, a_allowFullCrossOver, false);
    }

    public CrossoverOperator(Configuration a_configuration, int a_desiredCrossoverRate, boolean a_allowFullCrossOver, boolean a_xoverNewAge) throws InvalidConfigurationException {
        super(a_configuration);
        if (a_desiredCrossoverRate < 1) {
            throw new IllegalArgumentException("Crossover rate must be greater zero");
        }
        this.m_crossoverRate = a_desiredCrossoverRate;
        this.m_crossoverRatePercent = -1.0;
        this.setCrossoverRateCalc(null);
        this.setAllowFullCrossOver(a_allowFullCrossOver);
        this.setXoverNewAge(a_xoverNewAge);
    }

    public CrossoverOperator(Configuration a_configuration, double a_crossoverRatePercentage) throws InvalidConfigurationException {
        this(a_configuration, a_crossoverRatePercentage, true);
    }

    public CrossoverOperator(Configuration a_configuration, double a_crossoverRatePercentage, boolean a_allowFullCrossOver) throws InvalidConfigurationException {
        this(a_configuration, a_crossoverRatePercentage, a_allowFullCrossOver, false);
    }

    public CrossoverOperator(Configuration a_configuration, double a_crossoverRatePercentage, boolean a_allowFullCrossOver, boolean a_xoverNewAge) throws InvalidConfigurationException {
        super(a_configuration);
        if (a_crossoverRatePercentage <= 0.0) {
            throw new IllegalArgumentException("Crossover rate must be greater zero");
        }
        this.m_crossoverRatePercent = a_crossoverRatePercentage;
        this.m_crossoverRate = -1;
        this.setCrossoverRateCalc(null);
        this.setAllowFullCrossOver(a_allowFullCrossOver);
        this.setXoverNewAge(a_xoverNewAge);
    }

    @Override
    public void operate(Population a_population, List a_candidateChromosomes) {
        int size = Math.min(this.getConfiguration().getPopulationSize(), a_population.size());
        int numCrossovers = 0;
        numCrossovers = this.m_crossoverRate >= 0 ? size / this.m_crossoverRate : (this.m_crossoverRateCalc != null ? size / this.m_crossoverRateCalc.calculateCurrentRate() : (int)((double)size * this.m_crossoverRatePercent));
        RandomGenerator generator = this.getConfiguration().getRandomGenerator();
        IGeneticOperatorConstraint constraint = this.getConfiguration().getJGAPFactory().getGeneticOperatorConstraint();
        for (int i = 0; i < numCrossovers; ++i) {
            int index1 = generator.nextInt(size);
            int index2 = generator.nextInt(size);
            IChromosome chrom1 = a_population.getChromosome(index1);
            IChromosome chrom2 = a_population.getChromosome(index2);
            if (!this.isXoverNewAge() && chrom1.getAge() < 1 && chrom2.getAge() < 1) continue;
            if (constraint != null) {
                Vector<IChromosome> v = new Vector<IChromosome>();
                v.add(chrom1);
                v.add(chrom2);
                if (!constraint.isValid(a_population, v, this)) continue;
            }
            IChromosome firstMate = (IChromosome)chrom1.clone();
            IChromosome secondMate = (IChromosome)chrom2.clone();
            if (this.m_monitorActive) {
                firstMate.setUniqueIDTemplate(chrom1.getUniqueID(), 1);
                firstMate.setUniqueIDTemplate(chrom2.getUniqueID(), 2);
                secondMate.setUniqueIDTemplate(chrom1.getUniqueID(), 1);
                secondMate.setUniqueIDTemplate(chrom2.getUniqueID(), 2);
            }
            this.doCrossover(firstMate, secondMate, a_candidateChromosomes, generator);
        }
    }

    protected void doCrossover(IChromosome firstMate, IChromosome secondMate, List a_candidateChromosomes, RandomGenerator generator) {
        int locus;
        Gene[] firstGenes = firstMate.getGenes();
        Gene[] secondGenes = secondMate.getGenes();
        for (int j = locus = generator.nextInt(firstGenes.length); j < firstGenes.length; ++j) {
            Gene gene1;
            int index = 0;
            if (firstGenes[j] instanceof ICompositeGene) {
                index = generator.nextInt(firstGenes[j].size());
                gene1 = ((ICompositeGene)firstGenes[j]).geneAt(index);
            } else {
                gene1 = firstGenes[j];
            }
            Gene gene2 = secondGenes[j] instanceof ICompositeGene ? ((ICompositeGene)secondGenes[j]).geneAt(index) : secondGenes[j];
            if (this.m_monitorActive) {
                gene1.setUniqueIDTemplate(gene2.getUniqueID(), 1);
                gene2.setUniqueIDTemplate(gene1.getUniqueID(), 1);
            }
            Object firstAllele = gene1.getAllele();
            gene1.setAllele(gene2.getAllele());
            gene2.setAllele(firstAllele);
        }
        a_candidateChromosomes.add(firstMate);
        a_candidateChromosomes.add(secondMate);
    }

    private void setCrossoverRateCalc(IUniversalRateCalculator a_crossoverRateCalculator) {
        this.m_crossoverRateCalc = a_crossoverRateCalculator;
        if (a_crossoverRateCalculator != null) {
            this.m_crossoverRate = -1;
            this.m_crossoverRatePercent = -1.0;
        }
    }

    public int compareTo(Object a_other) {
        if (a_other == null) {
            return 1;
        }
        CrossoverOperator op = (CrossoverOperator)a_other;
        if (this.m_crossoverRateCalc == null) {
            if (op.m_crossoverRateCalc != null) {
                return -1;
            }
        } else if (op.m_crossoverRateCalc == null) {
            return 1;
        }
        if (this.m_crossoverRate != op.m_crossoverRate) {
            if (this.m_crossoverRate > op.m_crossoverRate) {
                return 1;
            }
            return -1;
        }
        if (this.m_allowFullCrossOver != op.m_allowFullCrossOver) {
            if (this.m_allowFullCrossOver) {
                return 1;
            }
            return -1;
        }
        if (this.m_xoverNewAge != op.m_xoverNewAge) {
            if (this.m_xoverNewAge) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public void setAllowFullCrossOver(boolean a_allowFullXOver) {
        this.m_allowFullCrossOver = a_allowFullXOver;
    }

    public boolean isAllowFullCrossOver() {
        return this.m_allowFullCrossOver;
    }

    public int getCrossOverRate() {
        return this.m_crossoverRate;
    }

    public double getCrossOverRatePercent() {
        return this.m_crossoverRatePercent;
    }

    public void setXoverNewAge(boolean a_xoverNewAge) {
        this.m_xoverNewAge = a_xoverNewAge;
    }

    public boolean isXoverNewAge() {
        return this.m_xoverNewAge;
    }
}

