/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Random;
import org.jgap.RandomGenerator;

public class CauchyRandomGenerator
implements RandomGenerator {
    private static final String CVS_REVISION = "$Revision: 1.15 $";
    private double m_scale;
    private double m_location;
    private Random m_rn;

    public CauchyRandomGenerator() {
        this(0.0, 1.0);
    }

    public CauchyRandomGenerator(double a_location, double a_scale) {
        this.m_location = a_location;
        this.m_scale = a_scale;
        this.m_rn = new Random();
    }

    @Override
    public int nextInt() {
        return Math.min(0x7FFFFFFE, (int)Math.round(this.nextCauchy() * 2.147483647E9));
    }

    @Override
    public int nextInt(int a_ceiling) {
        return Math.min(a_ceiling - 1, (int)Math.round(this.nextCauchy() * (double)a_ceiling));
    }

    @Override
    public long nextLong() {
        return Math.min(0x7FFFFFFFFFFFFFFEL, Math.round(this.nextCauchy() * 9.223372036854776E18));
    }

    @Override
    public double nextDouble() {
        return this.nextCauchy();
    }

    @Override
    public float nextFloat() {
        return Math.min(Float.MAX_VALUE, (float)(this.nextCauchy() * 3.4028234663852886E38));
    }

    @Override
    public boolean nextBoolean() {
        return this.nextCauchy() >= 0.5;
    }

    public double nextCauchy() {
        return 0.5 + Math.atan((this.m_rn.nextDouble() - this.m_location) / this.m_scale) / Math.PI;
    }

    public double getCauchyStandardDeviation() {
        return this.m_scale;
    }

    private void readObject(ObjectInputStream a_inputStream) throws IOException, ClassNotFoundException {
        a_inputStream.defaultReadObject();
        this.m_rn.setSeed(System.currentTimeMillis());
    }
}

