/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.jgap.Configuration;
import org.jgap.GeneticOperator;
import org.jgap.IJGAPFactory;
import org.jgap.InvalidConfigurationException;
import org.jgap.distr.Culture;
import org.jgap.distr.CultureMemoryCell;
import org.jgap.event.EventManager;
import org.jgap.gp.CommandGene;
import org.jgap.gp.CrossMethod;
import org.jgap.gp.GPFitnessFunction;
import org.jgap.gp.IGPFitnessEvaluator;
import org.jgap.gp.IGPInitStrategy;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.INaturalGPSelector;
import org.jgap.gp.INodeValidator;
import org.jgap.gp.impl.BranchTypingCross;
import org.jgap.gp.impl.DefaultGPFitnessEvaluator;
import org.jgap.gp.impl.GPProgram;
import org.jgap.gp.impl.GPProgramInfo;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.gp.impl.TournamentSelector;
import org.jgap.gp.terminal.Variable;
import org.jgap.impl.JGAPFactory;
import org.jgap.impl.StockRandomGenerator;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class GPConfiguration
extends Configuration {
    private static final String CVS_REVISION = "$Revision: 1.49 $";
    private GPFitnessFunction m_objectiveFunction;
    private Stack m_stack = new Stack();
    private transient Culture m_memory = new Culture(50);
    private transient Hashtable<String, char[][]> m_matrices;
    private double m_crossoverProb = 0.9;
    private double m_reproductionProb = 0.1;
    private double m_mutationProb = 0.1;
    private double m_dynArityProb = 0.08;
    private double m_newChromsPercent = 0.3;
    private double m_functionProb = 0.9;
    private int m_maxCrossoverDepth = 17;
    private int m_maxInitDepth = 7;
    private int m_minInitDepth = 2;
    private INaturalGPSelector m_selectionMethod;
    private CrossMethod m_crossMethod;
    private boolean m_strictProgramCreation;
    private int m_programCreationMaxTries = 5;
    private IGPFitnessEvaluator m_fitnessEvaluator;
    private INodeValidator m_nodeValidator;
    private transient boolean m_warningPrinted;
    private IGPProgram m_prototypeProgram;
    private boolean m_useProgramCache = false;
    private Map m_variables;
    private transient Map m_programCache;
    private transient IJGAPFactory m_factory;
    private IGPInitStrategy m_initStrategy;
    private boolean m_verify;
    private boolean m_noCommandGeneCloning;

    public GPConfiguration() throws InvalidConfigurationException {
        this("", null);
    }

    public GPConfiguration(String a_id, String a_name) throws InvalidConfigurationException {
        super(a_id, a_name);
        this.init(true);
        this.m_selectionMethod = new TournamentSelector(3);
    }

    public GPConfiguration(String a_name) throws InvalidConfigurationException {
        this();
        this.setName(a_name);
    }

    public void setGPFitnessEvaluator(IGPFitnessEvaluator a_evaluator) {
        this.m_fitnessEvaluator = a_evaluator;
    }

    protected void init(boolean a_fullInit) throws InvalidConfigurationException {
        String clazz = System.getProperty("JGAPFACTORYCLASS");
        if (clazz != null && clazz.length() > 0) {
            try {
                this.m_factory = (IJGAPFactory)Class.forName(clazz).newInstance();
            }
            catch (Throwable ex) {
                throw new RuntimeException("Class " + clazz + " could not be instantiated" + " as type IJGAPFactory");
            }
        } else {
            this.m_factory = new JGAPFactory(false);
        }
        if (this.m_factory == null) {
            throw new IllegalStateException("JGAPFactory not registered!");
        }
        this.m_programCache = new HashMap(50);
        this.m_matrices = new Hashtable();
        if (a_fullInit) {
            this.m_variables = new Hashtable();
            this.m_crossMethod = new BranchTypingCross(this);
            this.setEventManager(new EventManager());
            this.setRandomGenerator(new StockRandomGenerator());
            this.setGPFitnessEvaluator(new DefaultGPFitnessEvaluator());
        }
    }

    public GPConfiguration(INaturalGPSelector a_selectionMethod) throws InvalidConfigurationException {
        this.init(true);
        this.m_selectionMethod = a_selectionMethod;
    }

    public void setSelectionMethod(INaturalGPSelector a_method) {
        if (a_method == null) {
            throw new IllegalArgumentException("Selection method must not be null");
        }
        this.m_selectionMethod = a_method;
    }

    public void setCrossoverMethod(CrossMethod a_method) {
        if (a_method == null) {
            throw new IllegalArgumentException("Crossover method must not be null");
        }
        this.m_crossMethod = a_method;
    }

    @Override
    public synchronized void verifyStateIsValid() throws InvalidConfigurationException {
    }

    @Override
    public synchronized void addGeneticOperator(GeneticOperator a_operatorToAdd) throws InvalidConfigurationException {
        throw new UnsupportedOperationException("Use addGeneticOperator(GPGeneticOperator) instead!");
    }

    public double getCrossoverProb() {
        return this.m_crossoverProb;
    }

    public void setCrossoverProb(float a_crossoverProb) {
        this.m_crossoverProb = a_crossoverProb;
    }

    public double getReproductionProb() {
        return this.m_reproductionProb;
    }

    public void setReproductionProb(float a_reproductionProb) {
        this.m_reproductionProb = a_reproductionProb;
    }

    public double getMutationProb() {
        return this.m_mutationProb;
    }

    public void setMutationProb(float a_mutationProb) {
        this.m_mutationProb = a_mutationProb;
    }

    public double getDynamizeArityProb() {
        return this.m_dynArityProb;
    }

    public void setDynamizeArityProb(float a_dynArityProb) {
        this.m_dynArityProb = a_dynArityProb;
    }

    public void setFunctionProb(double a_functionProb) {
        this.m_functionProb = a_functionProb;
    }

    public double getFunctionProb() {
        return this.m_functionProb;
    }

    public void setNewChromsPercent(double a_newChromsPercent) {
        if (this.m_newChromsPercent >= 1.0) {
            throw new IllegalArgumentException("Parameter value must be smaller than 1!");
        }
        this.m_newChromsPercent = a_newChromsPercent;
    }

    public double getNewChromsPercent() {
        return this.m_newChromsPercent;
    }

    public int getMaxCrossoverDepth() {
        return this.m_maxCrossoverDepth;
    }

    public void setMaxCrossoverDepth(int a_maxCrossoverDepth) {
        this.m_maxCrossoverDepth = a_maxCrossoverDepth;
    }

    public INaturalGPSelector getSelectionMethod() {
        return this.m_selectionMethod;
    }

    public CrossMethod getCrossMethod() {
        return this.m_crossMethod;
    }

    public int getMaxInitDepth() {
        return this.m_maxInitDepth;
    }

    public void setMaxInitDepth(int a_maxDepth) {
        this.m_maxInitDepth = a_maxDepth;
    }

    public int getMinInitDepth() {
        return this.m_minInitDepth;
    }

    public void setMinInitDepth(int a_minDepth) {
        this.m_minInitDepth = a_minDepth;
    }

    public void pushToStack(Object a_value) {
        this.m_stack.push(a_value);
    }

    public Object popFromStack() {
        return this.m_stack.pop();
    }

    public Object peekStack() {
        return this.m_stack.peek();
    }

    public int stackSize() {
        return this.m_stack.size();
    }

    public void clearStack() {
        this.m_stack.clear();
    }

    public void storeInMemory(String a_name, Object a_value) {
        this.m_memory.set(a_name, a_value, -1);
    }

    public void createMatrix(String a_name, int a_cols, int a_rows) {
        if (a_name == null || a_name.length() < 1) {
            throw new IllegalArgumentException("Matrix name must not be empty!");
        }
        if (a_cols < 1 || a_rows < 1) {
            throw new IllegalArgumentException("Number of colums and rows must be greater than zero!");
        }
        char[][] m_matrix = new char[a_cols][a_rows];
        this.m_matrices.put(a_name, m_matrix);
    }

    public void setMatrix(String a_name, int a_col, int a_row, char a_value) {
        char[][] m_matrix = this.m_matrices.get(a_name);
        if (m_matrix == null) {
            throw new IllegalArgumentException("Matrix with name " + a_name + " not found!");
        }
        m_matrix[a_col][a_row] = a_value;
    }

    public void resetMatrix(String a_name, char a_filler) {
        char[][] m_matrix = this.m_matrices.get(a_name);
        if (m_matrix == null) {
            throw new IllegalArgumentException("Matrix with name " + a_name + " not found!");
        }
        for (int col = 0; col < m_matrix.length; ++col) {
            for (int row = 0; row < m_matrix[col].length; ++row) {
                m_matrix[col][row] = a_filler;
            }
        }
    }

    public char readMatrix(String a_name, int a_col, int a_row) {
        char[][] m_matrix = this.m_matrices.get(a_name);
        if (m_matrix == null) {
            throw new IllegalArgumentException("Matrix with name " + a_name + " not found!");
        }
        return m_matrix[a_col][a_row];
    }

    public char[][] getMatrix(String a_name) {
        char[][] m_matrix = this.m_matrices.get(a_name);
        return m_matrix;
    }

    public CultureMemoryCell storeMatrixMemory(int a_x, int a_y, Object a_value) {
        return this.m_memory.setMatrix(a_x, a_y, a_value);
    }

    public Object readMatrixMemory(int a_x, int a_y) {
        return this.m_memory.getMatrix(a_x, a_y).getCurrentValue();
    }

    public Object readFromMemory(String a_name) {
        return this.m_memory.get(a_name).getCurrentValue();
    }

    public Object readFromMemoryIfExists(String a_name) {
        CultureMemoryCell cell = null;
        try {
            cell = this.m_memory.get(a_name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (cell == null) {
            return null;
        }
        return cell.getCurrentValue();
    }

    public CultureMemoryCell storeIndexedMemory(int a_index, Object a_value) {
        return this.m_memory.set(a_index, a_value, -1, "noname");
    }

    public Object readIndexedMemory(int a_index) {
        CultureMemoryCell cell = this.m_memory.get(a_index);
        if (cell == null) {
            return null;
        }
        return cell.getCurrentValue();
    }

    public void clearMemory() {
        this.m_memory.clear();
    }

    public GPFitnessFunction getGPFitnessFunction() {
        return this.m_objectiveFunction;
    }

    public void setFitnessEvaluator(IGPFitnessEvaluator a_fitnessEvaluator) {
        this.setGPFitnessEvaluator(a_fitnessEvaluator);
    }

    public synchronized void setFitnessFunction(GPFitnessFunction a_functionToSet) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_functionToSet == null) {
            throw new InvalidConfigurationException("The FitnessFunction instance must not be null.");
        }
        this.checkProperty("JGAPFITFUNCINST", a_functionToSet, this.m_objectiveFunction, "Fitness function has already been set differently.");
        this.m_objectiveFunction = a_functionToSet;
    }

    public boolean isStrictProgramCreation() {
        return this.m_strictProgramCreation;
    }

    public void setStrictProgramCreation(boolean a_strict) {
        this.m_strictProgramCreation = a_strict;
    }

    public int getProgramCreationMaxtries() {
        return this.m_programCreationMaxTries;
    }

    public void setProgramCreationMaxTries(int a_maxtries) {
        this.m_programCreationMaxTries = a_maxtries;
    }

    public IGPFitnessEvaluator getGPFitnessEvaluator() {
        return this.m_fitnessEvaluator;
    }

    public boolean validateNode(ProgramChromosome a_chrom, CommandGene a_node, CommandGene a_rootNode, int a_tries, int a_num, int a_recurseLevel, Class a_type, CommandGene[] a_functionSet, int a_depth, boolean a_grow, int a_childIndex, boolean a_fullProgram) {
        INodeValidator nodeValidator = this.getNodeValidator();
        if (nodeValidator == null) {
            return true;
        }
        return nodeValidator.validate(a_chrom, a_node, a_rootNode, a_tries, a_num, a_recurseLevel, a_type, a_functionSet, a_depth, a_grow, a_childIndex, a_fullProgram);
    }

    public void setNodeValidator(INodeValidator a_nodeValidator) {
        this.m_nodeValidator = a_nodeValidator;
    }

    public INodeValidator getNodeValidator() {
        return this.m_nodeValidator;
    }

    @Override
    public boolean equals(Object a_other) {
        try {
            return this.compareTo(a_other) == 0;
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    @Override
    public int compareTo(Object a_other) {
        if (a_other == null) {
            return 1;
        }
        GPConfiguration other = (GPConfiguration)a_other;
        return new CompareToBuilder().append((Object)this.m_objectiveFunction, (Object)other.m_objectiveFunction).append(this.m_crossoverProb, other.m_crossoverProb).append(this.m_reproductionProb, other.m_reproductionProb).append(this.m_newChromsPercent, other.m_newChromsPercent).append(this.m_maxCrossoverDepth, other.m_maxCrossoverDepth).append(this.m_maxInitDepth, other.m_maxInitDepth).append(this.m_selectionMethod.getClass(), other.m_selectionMethod.getClass()).append(this.m_crossMethod.getClass(), other.m_crossMethod.getClass()).append(this.m_programCreationMaxTries, other.m_programCreationMaxTries).append(this.m_strictProgramCreation, other.m_strictProgramCreation).append(this.m_fitnessEvaluator.getClass(), other.m_fitnessEvaluator.getClass()).toComparison();
    }

    public boolean isMaxNodeWarningPrinted() {
        return this.m_warningPrinted;
    }

    public void flagMaxNodeWarningPrinted() {
        this.m_warningPrinted = true;
    }

    public void setPrototypeProgram(IGPProgram a_program) {
        this.m_prototypeProgram = a_program;
    }

    public IGPProgram getPrototypeProgram() {
        return this.m_prototypeProgram;
    }

    public int getMemorySize() {
        return this.m_memory.size();
    }

    public GPProgramInfo readProgramCache(GPProgram a_prog) {
        GPProgramInfo pci = new GPProgramInfo(a_prog, true);
        pci.setFound(false);
        return (GPProgramInfo)this.m_programCache.get(pci.getToStringNorm());
    }

    public GPProgramInfo putToProgramCache(GPProgram a_prog) {
        GPProgramInfo pci = new GPProgramInfo(a_prog, true);
        return this.m_programCache.put(pci.getToStringNorm(), pci);
    }

    public boolean isUseProgramCache() {
        return this.m_useProgramCache;
    }

    public void setUseProgramCache(boolean a_useCache) {
        this.m_useProgramCache = a_useCache;
    }

    public void putVariable(Variable a_var) {
        this.m_variables.put(a_var.getName(), a_var);
    }

    public Variable getVariable(String a_varName) {
        return (Variable)this.m_variables.get(a_varName);
    }

    @Override
    public Object clone() {
        return this.newInstanceGP(this.getId(), this.getName());
    }

    public GPConfiguration newInstanceGP(String a_id, String a_name) {
        try {
            int popSize;
            GPConfiguration result = new GPConfiguration(this.getName());
            if (this.m_factory instanceof ICloneable) {
                result.m_factory = (IJGAPFactory)((ICloneable)((Object)this.m_factory)).clone();
            } else {
                this.m_factory = new JGAPFactory(false);
                result.m_factory = (IJGAPFactory)((JGAPFactory)this.m_factory).clone();
            }
            if (result.m_factory == null) {
                throw new IllegalStateException("JGAPFactory must not be null!");
            }
            if (this.m_objectiveFunction != null) {
                result.m_objectiveFunction = this.m_objectiveFunction;
            }
            if ((popSize = this.getPopulationSize()) > 0) {
                result.setPopulationSize(popSize);
            }
            result.m_crossoverProb = this.m_crossoverProb;
            result.m_reproductionProb = this.m_reproductionProb;
            result.m_newChromsPercent = this.m_newChromsPercent;
            result.m_functionProb = this.m_functionProb;
            result.m_maxCrossoverDepth = this.m_maxCrossoverDepth;
            result.m_maxInitDepth = this.m_maxInitDepth;
            result.m_minInitDepth = this.m_minInitDepth;
            result.m_strictProgramCreation = this.m_strictProgramCreation;
            result.m_programCreationMaxTries = this.m_programCreationMaxTries;
            result.m_selectionMethod = (INaturalGPSelector)this.doClone(this.m_selectionMethod);
            result.m_crossMethod = (CrossMethod)this.doClone(this.m_crossMethod);
            result.m_fitnessEvaluator = (IGPFitnessEvaluator)this.doClone(this.m_fitnessEvaluator);
            result.m_nodeValidator = (INodeValidator)this.doClone(this.m_nodeValidator);
            result.m_useProgramCache = this.m_useProgramCache;
            result.m_verify = this.m_verify;
            result.setName(a_name);
            result.setId(a_id);
            result.makeThreadKey();
            return result;
        }
        catch (Throwable t) {
            throw new CloneException(t);
        }
    }

    @Override
    public IJGAPFactory getJGAPFactory() {
        return this.m_factory;
    }

    private void readObject(ObjectInputStream a_inputStream) throws IOException, ClassNotFoundException {
        a_inputStream.defaultReadObject();
        try {
            this.init(false);
        }
        catch (InvalidConfigurationException iex) {
            iex.printStackTrace();
            throw new IOException(iex.toString());
        }
    }

    public void setInitStrategy(IGPInitStrategy a_strategy) {
        this.m_initStrategy = a_strategy;
    }

    public IGPInitStrategy getInitStrategy() {
        return this.m_initStrategy;
    }

    public void setVerifyPrograms(boolean a_verify) {
        this.m_verify = a_verify;
    }

    public boolean isVerifyPrograms() {
        return this.m_verify;
    }

    public void setNoCommandGeneCloning(boolean a_noCommandGeneCloning) {
        this.m_noCommandGeneCloning = a_noCommandGeneCloning;
    }

    public boolean isNoCommandGeneCloning() {
        return this.m_noCommandGeneCloning;
    }
}

