/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class IfElse
extends CommandGene
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.14 $";
    private Class m_type;

    public IfElse(GPConfiguration a_conf, Class a_type) throws InvalidConfigurationException {
        this(a_conf, a_type, 0, null);
    }

    public IfElse(GPConfiguration a_conf, Class a_type, int a_subReturnType, int[] a_subChildTypes) throws InvalidConfigurationException {
        super(a_conf, 3, CommandGene.VoidClass, a_subReturnType, a_subChildTypes);
        this.m_type = a_type;
    }

    @Override
    public String toString() {
        return "if(&1) then (&2) else(&3)";
    }

    @Override
    public String getName() {
        return "IfElse";
    }

    @Override
    public boolean execute_boolean(ProgramChromosome c, int n, Object[] args) {
        boolean condition;
        this.check(c);
        if (this.m_type == CommandGene.IntegerClass) {
            condition = c.execute_int(n, 0, args) > 0;
        } else if (this.m_type == CommandGene.BooleanClass) {
            condition = c.execute_boolean(n, 0, args);
        } else if (this.m_type == CommandGene.LongClass) {
            condition = c.execute_long(n, 0, args) > 0L;
        } else if (this.m_type == CommandGene.DoubleClass) {
            condition = c.execute_double(n, 0, args) > 0.0;
        } else if (this.m_type == CommandGene.FloatClass) {
            condition = c.execute_float(n, 0, args) > 0.0f;
        } else {
            throw new IllegalStateException("IfElse: cannot process type " + this.m_type);
        }
        if (condition) {
            return c.execute_boolean(n, 1, args);
        }
        return c.execute_boolean(n, 2, args);
    }

    @Override
    public int execute_int(ProgramChromosome c, int n, Object[] args) {
        boolean condition;
        this.check(c);
        if (this.m_type == CommandGene.IntegerClass) {
            condition = c.execute_int(n, 0, args) > 0;
        } else if (this.m_type == CommandGene.BooleanClass) {
            condition = c.execute_boolean(n, 0, args);
        } else if (this.m_type == CommandGene.LongClass) {
            condition = c.execute_long(n, 0, args) > 0L;
        } else if (this.m_type == CommandGene.DoubleClass) {
            condition = c.execute_double(n, 0, args) > 0.0;
        } else if (this.m_type == CommandGene.FloatClass) {
            condition = c.execute_float(n, 0, args) > 0.0f;
        } else {
            throw new IllegalStateException("IfElse: cannot process type " + this.m_type);
        }
        if (condition) {
            return c.execute_int(n, 1, args);
        }
        return c.execute_int(n, 2, args);
    }

    @Override
    public void execute_void(ProgramChromosome c, int n, Object[] args) {
        boolean condition;
        this.check(c);
        if (this.m_type == CommandGene.IntegerClass) {
            condition = c.execute_int(n, 0, args) > 0;
        } else if (this.m_type == CommandGene.BooleanClass) {
            condition = c.execute_boolean(n, 0, args);
        } else if (this.m_type == CommandGene.LongClass) {
            condition = c.execute_long(n, 0, args) > 0L;
        } else if (this.m_type == CommandGene.DoubleClass) {
            condition = c.execute_double(n, 0, args) > 0.0;
        } else if (this.m_type == CommandGene.FloatClass) {
            condition = c.execute_float(n, 0, args) > 0.0f;
        } else {
            throw new IllegalStateException("IfElse: cannot process type " + this.m_type);
        }
        if (condition) {
            c.execute_void(n, 1, args);
        } else {
            c.execute_void(n, 2, args);
        }
    }

    @Override
    public Class getChildType(IGPProgram a_ind, int a_chromNum) {
        if (a_chromNum == 0) {
            return this.m_type;
        }
        return CommandGene.VoidClass;
    }

    @Override
    public Object clone() {
        try {
            IfElse result = new IfElse(this.getGPConfiguration(), this.m_type, this.getSubReturnType(), this.getSubChildTypes());
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }

    @Override
    public boolean equals(Object a_other) {
        if (a_other == null || !(a_other instanceof IfElse)) {
            return false;
        }
        if (!super.equals(a_other)) {
            return false;
        }
        IfElse other = (IfElse)a_other;
        return new EqualsBuilder().append((Object)this.m_type, (Object)other.m_type).isEquals();
    }
}

