/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.distr.grid;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.client.GridClient;
import org.homedns.dade.jcgrid.client.GridNodeClientConfig;
import org.homedns.dade.jcgrid.cmd.MainCmd;
import org.homedns.dade.jcgrid.message.GridMessageWorkRequest;
import org.homedns.dade.jcgrid.message.GridMessageWorkResult;
import org.jgap.Configuration;
import org.jgap.distr.grid.DefaultClientFeedback;
import org.jgap.distr.grid.IClientEvolveStrategy;
import org.jgap.distr.grid.IClientFeedback;
import org.jgap.distr.grid.IGridConfiguration;
import org.jgap.distr.grid.IRequestSplitStrategy;
import org.jgap.distr.grid.JGAPRequest;
import org.jgap.distr.grid.JGAPResult;

public class JGAPClient
extends Thread {
    private static final String CVS_REVISION = "$Revision: 1.14 $";
    private static final String className = JGAPClient.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    protected GridNodeClientConfig m_gridconfig;
    protected JGAPRequest m_workReq;
    private GridClient m_gc;
    private IGridConfiguration m_gridConfig;

    public JGAPClient(GridNodeClientConfig a_gridconfig, String a_clientClassName) throws Exception {
        this.m_gridconfig = a_gridconfig;
        Class<?> client = Class.forName(a_clientClassName);
        this.m_gridConfig = (IGridConfiguration)client.getConstructor(new Class[0]).newInstance(new Object[0]);
        this.m_gridConfig.initialize(this.m_gridconfig);
        JGAPRequest req = new JGAPRequest(this.m_gridconfig.getSessionName(), 0, this.m_gridConfig.getConfiguration());
        req.setWorkerReturnStrategy(this.m_gridConfig.getWorkerReturnStrategy());
        req.setGenotypeInitializer(this.m_gridConfig.getGenotypeInitializer());
        req.setEvolveStrategy(this.m_gridConfig.getWorkerEvolveStrategy());
        req.setEvolveStrategy(null);
        this.setWorkRequest(req);
        this.start();
        this.join();
    }

    public void setWorkRequest(JGAPRequest a_request) {
        this.m_workReq = a_request;
    }

    protected GridClient startClient() throws Exception {
        GridClient gc = new GridClient();
        gc.setNodeConfig(this.m_gridconfig);
        gc.start();
        return gc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block11: {
            try {
                if (this.m_gridConfig.getClientFeedback() == null) {
                    log.info((Object)"No feedback handler set, using DefaultClientFeedback");
                    this.m_gridConfig.setClientFeedback(new DefaultClientFeedback());
                }
                this.m_gc = this.startClient();
                try {
                    IClientEvolveStrategy clientEvolver = this.m_gridConfig.getClientEvolveStrategy();
                    if (clientEvolver != null) {
                        clientEvolver.initialize(this.m_gc, this.getConfiguration(), this.m_gridConfig.getClientFeedback());
                    }
                    this.evolve(this.m_gc);
                }
                finally {
                    try {
                        this.m_gc.stop();
                    }
                    catch (Exception ex) {}
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (this.m_gridConfig.getClientFeedback() == null) break block11;
                this.m_gridConfig.getClientFeedback().error("Error while doing the work", ex);
            }
        }
    }

    protected void sendWorkRequests(JGAPRequest[] a_workList) throws Exception {
        for (int i = 0; i < a_workList.length; ++i) {
            JGAPRequest req = a_workList[i];
            this.m_gridConfig.getClientFeedback().sendingFragmentRequest(req);
            this.m_gc.send(new GridMessageWorkRequest(req));
            if (this.isInterrupted()) break;
        }
    }

    protected void receiveWorkResults(JGAPRequest[] workList) throws Exception {
        IClientFeedback feedback = this.m_gridConfig.getClientFeedback();
        int idx = -1;
        for (int i = 0; i < workList.length; ++i) {
            feedback.setProgressValue(i + workList.length);
            this.m_gc.getGridMessageChannel();
            GridMessageWorkResult gmwr = (GridMessageWorkResult)this.m_gc.recv(i);
            JGAPResult workResult = (JGAPResult)gmwr.getWorkResult();
            this.m_gridConfig.getClientEvolveStrategy().resultReceived(workResult);
            idx = workResult.getRID();
            feedback.receivedFragmentResult(workList[idx], workResult, idx);
            if (this.isInterrupted()) break;
        }
    }

    protected void evolve(GridClient gc) throws Exception {
        block1: {
            IClientFeedback feedback = this.m_gridConfig.getClientFeedback();
            feedback.beginWork();
            IClientEvolveStrategy evolver = this.m_gridConfig.getClientEvolveStrategy();
            IRequestSplitStrategy splitter = this.m_gridConfig.getRequestSplitStrategy();
            int evolutionIndex = 0;
            do {
                JGAPRequest[] workRequests = evolver.generateWorkRequests(this.m_workReq, splitter, null);
                feedback.setProgressMaximum(0);
                feedback.setProgressMaximum(workRequests.length - 1);
                this.sendWorkRequests(workRequests);
                if (this.isInterrupted()) break block1;
                evolver.afterWorkRequestsSent();
                this.receiveWorkResults(workRequests);
                evolver.evolve();
                feedback.completeFrame(evolutionIndex);
            } while (!evolver.isEvolutionFinished(++evolutionIndex));
            evolver.onFinished();
        }
        this.m_gridConfig.getClientFeedback().endWork();
    }

    @Override
    public void start() {
        try {
            this.m_gridConfig.validate();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        super.start();
    }

    public Configuration getConfiguration() {
        return this.m_gridConfig.getConfiguration();
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Please provide a name of the grid configuration class to use");
            System.out.println("An example class would be examples.grid.fitnessDistributed.GridConfiguration");
            System.exit(1);
        }
        try {
            MainCmd.setUpLog4J("client", true);
            GridNodeClientConfig config = new GridNodeClientConfig();
            Options options = new Options();
            CommandLine cmd = MainCmd.parseCommonOptions(options, config, args);
            new JGAPClient(config, args[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

