/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.data.config;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import org.jgap.InvalidConfigurationException;
import org.jgap.data.config.ConfigException;
import org.jgap.data.config.ConfigFileReader;
import org.jgap.data.config.Configurable;
import org.jgap.data.config.ConfigurationHandler;

public class RootConfigurationHandler
implements ConfigurationHandler {
    private static final String CVS_REVISION = "$Revision: 1.12 $";
    private static final String CONFIG_NAMESPACE = "org.jgap.Configuration";
    private static final String GENETIC_OPS = "GeneticOperators";
    private static final String NATURAL_SELS = "NaturalSelectors";
    private Configurable m_configurable;

    @Override
    public String getName() {
        return "Configuration";
    }

    @Override
    public List getConfigProperties() {
        return null;
    }

    @Override
    public String getNS() {
        return CONFIG_NAMESPACE;
    }

    @Override
    public void readConfig() throws ConfigException, InvalidConfigurationException {
        ConfigFileReader.instance().setNS(CONFIG_NAMESPACE);
        String value = ConfigFileReader.instance().getValue("m_populationSize");
        try {
            if (value != null) {
                this.setConfigProperty(this.m_configurable, "m_populationSize", value);
            }
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            throw new InvalidConfigurationException(ex.getMessage());
        }
        RootConfigurationHandler.configureClass(GENETIC_OPS);
        RootConfigurationHandler.configureClass(NATURAL_SELS);
    }

    @Override
    public void setConfigurable(Configurable a_configurable) {
        this.m_configurable = a_configurable;
    }

    public void setConfigProperty(Object a_configurable, String a_propertyName, String a_value) throws IllegalAccessException {
        String configVarName = "m_config";
        Field configVar = RootConfigurationHandler.getPrivateField(a_configurable, configVarName);
        configVar.setAccessible(true);
        Object configObj = configVar.get(a_configurable);
        Field propertyVar = RootConfigurationHandler.getPrivateField(configObj, a_propertyName);
        propertyVar.setAccessible(true);
        Class<?> type = propertyVar.getType();
        if (type.equals(Boolean.TYPE)) {
            propertyVar.setBoolean(configObj, Boolean.valueOf(a_value));
        } else if (type.equals(Byte.TYPE)) {
            propertyVar.setByte(configObj, Byte.valueOf(a_value));
        } else if (type.equals(Character.TYPE)) {
            propertyVar.setChar(configObj, a_value.charAt(0));
        } else if (type.equals(Double.TYPE)) {
            propertyVar.setDouble(configObj, Double.valueOf(a_value));
        } else if (type.equals(Float.TYPE)) {
            propertyVar.setFloat(configObj, Float.valueOf(a_value).floatValue());
        } else if (type.equals(Integer.TYPE)) {
            propertyVar.setInt(configObj, Integer.valueOf(a_value));
        } else if (type.equals(Long.TYPE)) {
            propertyVar.setLong(configObj, Long.valueOf(a_value));
        } else if (type.equals(Short.TYPE)) {
            propertyVar.setShort(configObj, Short.valueOf(a_value));
        } else if (type.equals(String.class)) {
            propertyVar.set(configObj, a_value);
        } else {
            throw new RuntimeException("Unknown field type: " + type.getName());
        }
    }

    public static Field getPrivateField(Object a_instance, String a_fieldName) {
        Field[] fields = a_instance.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!a_fieldName.equals(fields[i].getName())) continue;
            fields[i].setAccessible(true);
            return fields[i];
        }
        return null;
    }

    public static void configureClass(String className) throws ConfigException {
        List values = ConfigFileReader.instance().getValues(className);
        if (values != null && values.size() > 0) {
            String cName = "";
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                try {
                    cName = (String)iter.next();
                    Class<?> genClass = Class.forName(cName);
                    Configurable conObj = (Configurable)genClass.newInstance();
                }
                catch (Exception ex) {
                    throw new ConfigException("Error while configuring " + className + "." + cName);
                }
            }
        }
    }
}

