/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.audit;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jgap.IChromosome;
import org.jgap.NaturalSelector;
import org.jgap.Population;
import org.jgap.eval.PopulationContext;
import org.jgap.eval.PopulationHistoryIndexed;

public class EvolutionEvaluator {
    private static final String CVS_REVISION = "$Revision: 1.3 $";
    private PopulationHistoryIndexed m_monitorData;
    private List<Integer> evolutionIndexes;

    public EvolutionEvaluator(PopulationHistoryIndexed a_monitorData) {
        if (a_monitorData == null) {
            throw new IllegalArgumentException("Data must not be null!");
        }
        this.m_monitorData = a_monitorData;
        this.evolutionIndexes = new Vector<Integer>();
    }

    public void evaluate() {
        Map<Integer, Map> data = this.m_monitorData.getPopulationsHistory();
        for (int evNo : data.keySet()) {
            this.evolutionIndexes.add(evNo);
        }
        Map<String, Map<IChromosome, List<Integer>>> chromIDs = this.gatherChromosomesIDs(data);
        Map<IChromosome, Map<Integer, List<IChromosome>>> chromTrack = this.trackChromosomes(data);
        int size = this.evolutionIndexes.size();
        for (int i = 0; i < size; ++i) {
            PopulationContext ctx1;
            int evNo;
            evNo = this.evolutionIndexes.get(i);
            Map<Integer, PopulationContext> eventsPops = this.m_monitorData.getPopulations(evNo);
            int index = 0;
            while ((ctx1 = eventsPops.get(1 + index * 2 + 0)) != null) {
                Population pop1 = ctx1.getPopulation();
                NaturalSelector selector = ctx1.getSelector();
                PopulationContext ctx2 = eventsPops.get(1 + index * 2 + 1);
                Population pop2 = ctx2.getPopulation();
            }
        }
    }

    private Map<IChromosome, Map<Integer, List<IChromosome>>> trackChromosomes(Map<Integer, Map> a_data) {
        int size = this.evolutionIndexes.size() - 1;
        Map contextMap = a_data.get(size);
        PopulationContext context = (PopulationContext)contextMap.get(999);
        Population finalPop = context.getPopulation();
        return this.trackChromosomes(a_data, finalPop);
    }

    private Map<IChromosome, Map<Integer, List<IChromosome>>> trackChromosomes(Map<Integer, Map> a_data, Population a_pop) {
        Hashtable<IChromosome, Map<Integer, List<IChromosome>>> chromosomesTrack = new Hashtable<IChromosome, Map<Integer, List<IChromosome>>>();
        int currentIndex = this.evolutionIndexes.size();
        if (currentIndex < 1) {
            return chromosomesTrack;
        }
        int evNo = this.evolutionIndexes.get(currentIndex - 1);
        Map contextMap = a_data.get(evNo);
        PopulationContext context = (PopulationContext)contextMap.get(999);
        Population previousPop = context.getPopulation();
        Hashtable evoMap = new Hashtable();
        for (int i = 0; i < a_pop.size(); ++i) {
            String uid;
            IChromosome chrom = a_pop.getChromosome(i);
            int uindex = 1;
            Vector<IChromosome> uids = new Vector<IChromosome>();
            do {
                uid = chrom.getUniqueIDTemplate(uindex++);
                IChromosome chrom0 = null;
                if (uid == null && uindex != 2) continue;
                for (int k = 0; k < previousPop.size() && !(chrom0 = previousPop.getChromosome(k)).getUniqueID().equals(uid); ++k) {
                }
                uids.add(chrom0);
                evoMap.put(evNo, uids);
                chromosomesTrack.put(chrom, evoMap);
            } while (uid != null);
        }
        return chromosomesTrack;
    }

    private Map<String, Map<IChromosome, List<Integer>>> gatherChromosomesIDs(Map<Integer, Map> a_data) {
        int size = this.evolutionIndexes.size() - 1;
        Hashtable<String, Map<IChromosome, List<Integer>>> chromIDs = new Hashtable<String, Map<IChromosome, List<Integer>>>();
        for (int i = 0; i <= size; ++i) {
            int evNo = this.evolutionIndexes.get(i);
            Map contextMap = a_data.get(evNo);
            for (PopulationContext ctx : contextMap.values()) {
                Population pop = ctx.getPopulation();
                for (int j = 0; j < pop.size(); ++j) {
                    List<Integer> valueList;
                    IChromosome chrom = pop.getChromosome(j);
                    Map entry = (Map)chromIDs.get(chrom.getUniqueID());
                    if (entry == null) {
                        valueList = new Vector<Integer>();
                        valueList.add(evNo);
                        Hashtable<IChromosome, List<Integer>> valueMap = new Hashtable<IChromosome, List<Integer>>();
                        valueMap.put(chrom, valueList);
                        chromIDs.put(chrom.getUniqueID(), valueMap);
                        continue;
                    }
                    valueList = (List)entry.values().iterator().next();
                    if (valueList.contains(evNo)) continue;
                    valueList.add(evNo);
                }
            }
        }
        return chromIDs;
    }
}

