/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import gnu.trove.THashMap;
import java.util.Map;
import org.jgap.FitnessFunction;
import org.jgap.IBusinessKey;
import org.jgap.IChromosome;
import org.jgap.IPersistentRepresentation;

public abstract class CachedFitnessFunction
extends FitnessFunction {
    private static final String CVS_REVISION = "$Revision: 1.4 $";
    private Map<String, Double> cachedFitnessValues;

    public CachedFitnessFunction() {
        this((Map<String, Double>)new THashMap());
    }

    public CachedFitnessFunction(Map<String, Double> cache) {
        this.cachedFitnessValues = cache;
    }

    @Override
    public final double getFitnessValue(IChromosome a_subject) {
        String businessKey = this.getBusinessKey(a_subject);
        if (businessKey == null) {
            return super.getFitnessValue(a_subject);
        }
        Double fitnessValue = this.cachedFitnessValues.get(businessKey);
        if (fitnessValue != null) {
            return fitnessValue;
        }
        double returnValue = super.getFitnessValue(a_subject);
        this.cachedFitnessValues.put(businessKey, returnValue);
        return returnValue;
    }

    protected String getBusinessKey(IChromosome a_subject) {
        Class<?> clazz = a_subject.getClass();
        String result = IBusinessKey.class.isAssignableFrom(clazz) ? ((IBusinessKey)((Object)a_subject)).getBusinessKey() : (IPersistentRepresentation.class.isAssignableFrom(clazz) ? ((IPersistentRepresentation)((Object)a_subject)).getPersistentRepresentation() : null);
        return result;
    }
}

