/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.EdgeSupport;
import edu.uci.ics.jung.visualization.control.SimpleEdgeSupport;
import edu.uci.ics.jung.visualization.control.SimpleVertexSupport;
import edu.uci.ics.jung.visualization.control.VertexSupport;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class EditingGraphMousePlugin<V, E>
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    protected VertexSupport<V, E> vertexSupport;
    protected EdgeSupport<V, E> edgeSupport;
    private Creating createMode = Creating.UNDETERMINED;

    public EditingGraphMousePlugin(Supplier<V> vertexFactory, Supplier<E> edgeFactory) {
        this(16, vertexFactory, edgeFactory);
    }

    public EditingGraphMousePlugin(int modifiers, Supplier<V> vertexFactory, Supplier<E> edgeFactory) {
        super(modifiers);
        this.cursor = Cursor.getPredefinedCursor(1);
        this.vertexSupport = new SimpleVertexSupport(vertexFactory);
        this.edgeSupport = new SimpleEdgeSupport(edgeFactory);
    }

    @Override
    public boolean checkModifiers(MouseEvent e) {
        return (e.getModifiers() & this.modifiers) != 0;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.checkModifiers(e)) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            Point p = e.getPoint();
            GraphElementAccessor pickSupport = vv.getPickSupport();
            if (pickSupport != null) {
                Object vertex = pickSupport.getVertex(vv.getModel().getGraphLayout(), ((Point2D)p).getX(), ((Point2D)p).getY());
                if (vertex != null) {
                    this.createMode = Creating.EDGE;
                    Graph graph = vv.getModel().getGraphLayout().getGraph();
                    EdgeType edgeType = graph.getDefaultEdgeType();
                    if ((e.getModifiers() & 1) != 0 && !(graph instanceof UndirectedGraph)) {
                        edgeType = EdgeType.DIRECTED;
                    }
                    this.edgeSupport.startEdgeCreate(vv, vertex, e.getPoint(), edgeType);
                } else {
                    this.createMode = Creating.VERTEX;
                    this.vertexSupport.startVertexCreate(vv, e.getPoint());
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.checkModifiers(e)) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            Point p = e.getPoint();
            Layout layout = vv.getGraphLayout();
            if (this.createMode == Creating.EDGE) {
                GraphElementAccessor pickSupport = vv.getPickSupport();
                Object vertex = null;
                if (pickSupport != null) {
                    vertex = pickSupport.getVertex(layout, ((Point2D)p).getX(), ((Point2D)p).getY());
                }
                this.edgeSupport.endEdgeCreate(vv, vertex);
            } else if (this.createMode == Creating.VERTEX) {
                this.vertexSupport.endVertexCreate(vv, e.getPoint());
            }
        }
        this.createMode = Creating.UNDETERMINED;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.checkModifiers(e)) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            if (this.createMode == Creating.EDGE) {
                this.edgeSupport.midEdgeCreate(vv, e.getPoint());
            } else if (this.createMode == Creating.VERTEX) {
                this.vertexSupport.midVertexCreate(vv, e.getPoint());
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(this.cursor);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public VertexSupport<V, E> getVertexSupport() {
        return this.vertexSupport;
    }

    public void setVertexSupport(VertexSupport<V, E> vertexSupport) {
        this.vertexSupport = vertexSupport;
    }

    public EdgeSupport<V, E> getEdgeSupport() {
        return this.edgeSupport;
    }

    public void setEdgeSupport(EdgeSupport<V, E> edgeSupport) {
        this.edgeSupport = edgeSupport;
    }

    private static enum Creating {
        EDGE,
        VERTEX,
        UNDETERMINED;

    }
}

