/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import com.google.common.base.Functions;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.VisualizationImageServer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.renderers.BasicVertexLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.GradientVertexRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.geom.Point2D;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class VisualizationImageServerDemo {
    DirectedSparseMultigraph<String, Number> graph = new DirectedSparseMultigraph();
    VisualizationImageServer<String, Number> vv;

    public VisualizationImageServerDemo() {
        String[] v = this.createVertices(10);
        this.createEdges(v);
        this.vv = new VisualizationImageServer<String, Number>(new KKLayout<String, Number>(this.graph), new Dimension(600, 600));
        this.vv.getRenderer().setVertexRenderer(new GradientVertexRenderer(Color.white, Color.red, Color.white, Color.blue, this.vv.getPickedVertexState(), false));
        this.vv.getRenderContext().setEdgeDrawPaintTransformer(Functions.constant((Object)Color.lightGray));
        this.vv.getRenderContext().setArrowFillPaintTransformer(Functions.constant((Object)Color.lightGray));
        this.vv.getRenderContext().setArrowDrawPaintTransformer(Functions.constant((Object)Color.lightGray));
        this.vv.getRenderContext().setVertexLabelTransformer(new ToStringLabeller());
        this.vv.getRenderer().getVertexLabelRenderer().setPositioner(new BasicVertexLabelRenderer.InsidePositioner());
        this.vv.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.AUTO);
        JFrame frame = new JFrame();
        Container content = frame.getContentPane();
        frame.setDefaultCloseOperation(3);
        Image im = this.vv.getImage(new Point2D.Double(300.0, 300.0), new Dimension(600, 600));
        ImageIcon icon = new ImageIcon(im);
        JLabel label = new JLabel(icon);
        content.add(label);
        frame.pack();
        frame.setVisible(true);
    }

    private String[] createVertices(int count) {
        String[] v = new String[count];
        for (int i = 0; i < count; ++i) {
            v[i] = "V" + i;
            this.graph.addVertex(v[i]);
        }
        return v;
    }

    void createEdges(String[] v) {
        this.graph.addEdge(new Double(Math.random()), v[0], v[1], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[0], v[3], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[0], v[4], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[4], v[5], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[3], v[5], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[1], v[2], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[1], v[4], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[8], v[2], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[3], v[8], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[6], v[7], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[7], v[5], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[0], v[9], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[9], v[8], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[7], v[6], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[6], v[5], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[4], v[2], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[5], v[4], EdgeType.DIRECTED);
    }

    public static void main(String[] args) {
        new VisualizationImageServerDemo();
    }
}

