/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.layout.PolarPoint;
import edu.uci.ics.jung.algorithms.layout.RadialTreeLayout;
import edu.uci.ics.jung.algorithms.layout.TreeLayout;
import edu.uci.ics.jung.graph.DelegateForest;
import edu.uci.ics.jung.graph.DelegateTree;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.Tree;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.layout.LayoutTransition;
import edu.uci.ics.jung.visualization.util.Animator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class TreeLayoutDemo
extends JApplet {
    Forest<String, Integer> graph;
    Supplier<DirectedGraph<String, Integer>> graphFactory = new Supplier<DirectedGraph<String, Integer>>(){

        public DirectedGraph<String, Integer> get() {
            return new DirectedSparseMultigraph<String, Integer>();
        }
    };
    Supplier<Tree<String, Integer>> treeFactory = new Supplier<Tree<String, Integer>>(){

        public Tree<String, Integer> get() {
            return new DelegateTree<String, Integer>(TreeLayoutDemo.this.graphFactory);
        }
    };
    Supplier<Integer> edgeFactory = new Supplier<Integer>(){
        int i = 0;

        public Integer get() {
            return this.i++;
        }
    };
    Supplier<String> vertexFactory = new Supplier<String>(){
        int i = 0;

        public String get() {
            return "V" + this.i++;
        }
    };
    VisualizationViewer<String, Integer> vv;
    VisualizationServer.Paintable rings;
    String root;
    TreeLayout<String, Integer> treeLayout;
    RadialTreeLayout<String, Integer> radialLayout;

    public TreeLayoutDemo() {
        this.graph = new DelegateForest<String, Integer>();
        this.createTree();
        this.treeLayout = new TreeLayout<String, Integer>(this.graph);
        this.radialLayout = new RadialTreeLayout<String, Integer>(this.graph);
        this.radialLayout.setSize(new Dimension(600, 600));
        this.vv = new VisualizationViewer<String, Integer>(this.treeLayout, new Dimension(600, 600));
        this.vv.setBackground(Color.white);
        this.vv.getRenderContext().setEdgeShapeTransformer(EdgeShape.line(this.graph));
        this.vv.getRenderContext().setVertexLabelTransformer(new ToStringLabeller());
        this.vv.setVertexToolTipTransformer(new ToStringLabeller());
        this.vv.getRenderContext().setArrowFillPaintTransformer(Functions.constant((Object)Color.lightGray));
        this.rings = new Rings();
        Container content = this.getContentPane();
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        content.add(panel);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(graphMouse);
        JComboBox<ModalGraphMouse.Mode> modeBox = graphMouse.getModeComboBox();
        modeBox.addItemListener(graphMouse.getModeListener());
        graphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scaler.scale(TreeLayoutDemo.this.vv, 1.1f, TreeLayoutDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scaler.scale(TreeLayoutDemo.this.vv, 0.9090909f, TreeLayoutDemo.this.vv.getCenter());
            }
        });
        JToggleButton radial = new JToggleButton("Radial");
        radial.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    LayoutTransition<String, Integer> lt = new LayoutTransition<String, Integer>(TreeLayoutDemo.this.vv, TreeLayoutDemo.this.treeLayout, TreeLayoutDemo.this.radialLayout);
                    Animator animator = new Animator(lt);
                    animator.start();
                    TreeLayoutDemo.this.vv.getRenderContext().getMultiLayerTransformer().setToIdentity();
                    TreeLayoutDemo.this.vv.addPreRenderPaintable(TreeLayoutDemo.this.rings);
                } else {
                    LayoutTransition<String, Integer> lt = new LayoutTransition<String, Integer>(TreeLayoutDemo.this.vv, TreeLayoutDemo.this.radialLayout, TreeLayoutDemo.this.treeLayout);
                    Animator animator = new Animator(lt);
                    animator.start();
                    TreeLayoutDemo.this.vv.getRenderContext().getMultiLayerTransformer().setToIdentity();
                    TreeLayoutDemo.this.vv.removePreRenderPaintable(TreeLayoutDemo.this.rings);
                }
                TreeLayoutDemo.this.vv.repaint();
            }
        });
        JPanel scaleGrid = new JPanel(new GridLayout(1, 0));
        scaleGrid.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel controls = new JPanel();
        scaleGrid.add(plus);
        scaleGrid.add(minus);
        controls.add(radial);
        controls.add(scaleGrid);
        controls.add(modeBox);
        content.add((Component)controls, "South");
    }

    private void createTree() {
        this.graph.addVertex("V0");
        this.graph.addEdge((Integer)this.edgeFactory.get(), "V0", "V1");
        this.graph.addEdge((Integer)this.edgeFactory.get(), "V0", "V2");
        this.graph.addEdge((Integer)this.edgeFactory.get(), "V1", "V4");
        this.graph.addEdge((Integer)this.edgeFactory.get(), "V2", "V3");
        this.graph.addEdge((Integer)this.edgeFactory.get(), "V2", "V5");
        this.graph.addEdge((Integer)this.edgeFactory.get(), "V4", "V6");
        this.graph.addEdge((Integer)this.edgeFactory.get(), "V4", "V7");
        this.graph.addEdge((Integer)this.edgeFactory.get(), "V3", "V8");
        this.graph.addEdge((Integer)this.edgeFactory.get(), "V6", "V9");
        this.graph.addEdge((Integer)this.edgeFactory.get(), "V4", "V10");
        this.graph.addVertex("A0");
        this.graph.addEdge((Integer)this.edgeFactory.get(), "A0", "A1");
        this.graph.addEdge((Integer)this.edgeFactory.get(), "A0", "A2");
        this.graph.addEdge((Integer)this.edgeFactory.get(), "A0", "A3");
        this.graph.addVertex("B0");
        this.graph.addEdge((Integer)this.edgeFactory.get(), "B0", "B1");
        this.graph.addEdge((Integer)this.edgeFactory.get(), "B0", "B2");
        this.graph.addEdge((Integer)this.edgeFactory.get(), "B1", "B4");
        this.graph.addEdge((Integer)this.edgeFactory.get(), "B2", "B3");
        this.graph.addEdge((Integer)this.edgeFactory.get(), "B2", "B5");
        this.graph.addEdge((Integer)this.edgeFactory.get(), "B4", "B6");
        this.graph.addEdge((Integer)this.edgeFactory.get(), "B4", "B7");
        this.graph.addEdge((Integer)this.edgeFactory.get(), "B3", "B8");
        this.graph.addEdge((Integer)this.edgeFactory.get(), "B6", "B9");
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        Container content = frame.getContentPane();
        frame.setDefaultCloseOperation(3);
        content.add(new TreeLayoutDemo());
        frame.pack();
        frame.setVisible(true);
    }

    class Rings
    implements VisualizationServer.Paintable {
        Collection<Double> depths = this.getDepths();

        private Collection<Double> getDepths() {
            HashSet<Double> depths = new HashSet<Double>();
            Map<String, PolarPoint> polarLocations = TreeLayoutDemo.this.radialLayout.getPolarLocations();
            for (String v : TreeLayoutDemo.this.graph.getVertices()) {
                PolarPoint pp = polarLocations.get(v);
                depths.add(pp.getRadius());
            }
            return depths;
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(Color.lightGray);
            Graphics2D g2d = (Graphics2D)g;
            Point2D center = TreeLayoutDemo.this.radialLayout.getCenter();
            Ellipse2D.Double ellipse = new Ellipse2D.Double();
            for (double d : this.depths) {
                ellipse.setFrameFromDiagonal(center.getX() - d, center.getY() - d, center.getX() + d, center.getY() + d);
                Shape shape = TreeLayoutDemo.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT).transform(ellipse);
                g2d.draw(shape);
            }
        }

        @Override
        public boolean useTransform() {
            return true;
        }
    }
}

