/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.renderers.DefaultEdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.DefaultVertexLabelRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ImageEdgeLabelDemo
extends JApplet {
    private static final long serialVersionUID = -4332663871914930864L;
    private static final int VERTEX_COUNT = 11;
    DirectedGraph<Number, Number> graph = new DirectedSparseMultigraph<Number, Number>();
    VisualizationViewer<Number, Number> vv;

    public ImageEdgeLabelDemo() {
        this.createGraph(11);
        FRLayout<Number, Number> layout = new FRLayout<Number, Number>(this.graph);
        layout.setMaxIterations(100);
        this.vv = new VisualizationViewer<Number, Number>(layout, new Dimension(400, 400));
        this.vv.getRenderContext().setEdgeDrawPaintTransformer(new PickableEdgePaintTransformer(this.vv.getPickedEdgeState(), Color.black, Color.cyan));
        this.vv.setBackground(Color.white);
        this.vv.getRenderContext().setVertexLabelRenderer(new DefaultVertexLabelRenderer(Color.cyan));
        this.vv.getRenderContext().setEdgeLabelRenderer(new DefaultEdgeLabelRenderer(Color.cyan));
        this.vv.getRenderContext().setEdgeLabelTransformer(new Function<Number, String>(){
            URL url = this.getClass().getResource("/images/lightning-s.gif");

            public String apply(Number input) {
                return "<html><img src=" + this.url + " height=10 width=21>";
            }
        });
        this.vv.setVertexToolTipTransformer(new ToStringLabeller());
        this.vv.setEdgeToolTipTransformer(new ToStringLabeller());
        Container content = this.getContentPane();
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        content.add(panel);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(graphMouse);
        this.vv.addKeyListener(graphMouse.getModeKeyListener());
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scaler.scale(ImageEdgeLabelDemo.this.vv, 1.1f, ImageEdgeLabelDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scaler.scale(ImageEdgeLabelDemo.this.vv, 0.9090909f, ImageEdgeLabelDemo.this.vv.getCenter());
            }
        });
        JComboBox<ModalGraphMouse.Mode> modeBox = graphMouse.getModeComboBox();
        JPanel modePanel = new JPanel();
        modePanel.setBorder(BorderFactory.createTitledBorder("Mouse Mode"));
        modePanel.add(modeBox);
        JPanel scaleGrid = new JPanel(new GridLayout(1, 0));
        scaleGrid.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel controls = new JPanel();
        scaleGrid.add(plus);
        scaleGrid.add(minus);
        controls.add(scaleGrid);
        controls.add(modePanel);
        content.add((Component)controls, "South");
    }

    private void createGraph(int vertexCount) {
        for (int i = 0; i < vertexCount; ++i) {
            this.graph.addVertex(i);
        }
        int j = 0;
        this.graph.addEdge(j++, 0, 1, EdgeType.DIRECTED);
        this.graph.addEdge(j++, 3, 0, EdgeType.DIRECTED);
        this.graph.addEdge(j++, 0, 4, EdgeType.DIRECTED);
        this.graph.addEdge(j++, 4, 5, EdgeType.DIRECTED);
        this.graph.addEdge(j++, 5, 3, EdgeType.DIRECTED);
        this.graph.addEdge(j++, 2, 1, EdgeType.DIRECTED);
        this.graph.addEdge(j++, 4, 1, EdgeType.DIRECTED);
        this.graph.addEdge(j++, 8, 2, EdgeType.DIRECTED);
        this.graph.addEdge(j++, 3, 8, EdgeType.DIRECTED);
        this.graph.addEdge(j++, 6, 7, EdgeType.DIRECTED);
        this.graph.addEdge(j++, 7, 5, EdgeType.DIRECTED);
        this.graph.addEdge(j++, 0, 9, EdgeType.DIRECTED);
        this.graph.addEdge(j++, 9, 8, EdgeType.DIRECTED);
        this.graph.addEdge(j++, 7, 6, EdgeType.DIRECTED);
        this.graph.addEdge(j++, 6, 5, EdgeType.DIRECTED);
        this.graph.addEdge(j++, 4, 2, EdgeType.DIRECTED);
        this.graph.addEdge(j++, 5, 4, EdgeType.DIRECTED);
        this.graph.addEdge(j++, 4, 10, EdgeType.DIRECTED);
        this.graph.addEdge(j++, 10, 4, EdgeType.DIRECTED);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        Container content = frame.getContentPane();
        frame.setDefaultCloseOperation(3);
        content.add(new ImageEdgeLabelDemo());
        frame.pack();
        frame.setVisible(true);
    }
}

