/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableVertexPaintTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.renderers.DefaultEdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.DefaultVertexLabelRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DrawnIconVertexDemo {
    Graph<Integer, Number> graph = new DirectedSparseGraph<Integer, Number>();
    VisualizationViewer<Integer, Number> vv;

    public DrawnIconVertexDemo() {
        Integer[] v = this.createVertices(10);
        this.createEdges(v);
        this.vv = new VisualizationViewer<Integer, Number>(new FRLayout<Integer, Number>(this.graph));
        this.vv.getRenderContext().setVertexLabelTransformer(new Function<Integer, String>(){

            public String apply(Integer v) {
                return "Vertex " + v;
            }
        });
        this.vv.getRenderContext().setVertexLabelRenderer(new DefaultVertexLabelRenderer(Color.cyan));
        this.vv.getRenderContext().setEdgeLabelRenderer(new DefaultEdgeLabelRenderer(Color.cyan));
        this.vv.getRenderContext().setVertexIconTransformer(new Function<Integer, Icon>(){

            public Icon apply(final Integer v) {
                return new Icon(){

                    @Override
                    public int getIconHeight() {
                        return 20;
                    }

                    @Override
                    public int getIconWidth() {
                        return 20;
                    }

                    @Override
                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        if (DrawnIconVertexDemo.this.vv.getPickedVertexState().isPicked(v)) {
                            g.setColor(Color.yellow);
                        } else {
                            g.setColor(Color.red);
                        }
                        g.fillOval(x, y, 20, 20);
                        if (DrawnIconVertexDemo.this.vv.getPickedVertexState().isPicked(v)) {
                            g.setColor(Color.black);
                        } else {
                            g.setColor(Color.white);
                        }
                        g.drawString("" + v, x + 6, y + 15);
                    }
                };
            }
        });
        this.vv.getRenderContext().setVertexFillPaintTransformer(new PickableVertexPaintTransformer(this.vv.getPickedVertexState(), Color.white, Color.yellow));
        this.vv.getRenderContext().setEdgeDrawPaintTransformer(new PickableEdgePaintTransformer(this.vv.getPickedEdgeState(), Color.black, Color.lightGray));
        this.vv.setBackground(Color.white);
        this.vv.setVertexToolTipTransformer(new ToStringLabeller());
        JFrame frame = new JFrame();
        Container content = frame.getContentPane();
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        content.add(panel);
        frame.setDefaultCloseOperation(3);
        DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(gm);
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scaler.scale(DrawnIconVertexDemo.this.vv, 1.1f, DrawnIconVertexDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scaler.scale(DrawnIconVertexDemo.this.vv, 0.9090909f, DrawnIconVertexDemo.this.vv.getCenter());
            }
        });
        JPanel controls = new JPanel();
        controls.add(plus);
        controls.add(minus);
        controls.add(gm.getModeComboBox());
        content.add((Component)controls, "South");
        frame.pack();
        frame.setVisible(true);
    }

    private Integer[] createVertices(int count) {
        Integer[] v = new Integer[count];
        for (int i = 0; i < count; ++i) {
            v[i] = new Integer(i);
            this.graph.addVertex(v[i]);
        }
        return v;
    }

    void createEdges(Integer[] v) {
        this.graph.addEdge(new Double(Math.random()), v[0], v[1], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[0], v[3], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[0], v[4], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[4], v[5], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[3], v[5], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[1], v[2], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[1], v[4], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[8], v[2], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[3], v[8], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[6], v[7], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[7], v[5], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[0], v[9], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[9], v[8], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[7], v[6], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[6], v[5], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[4], v[2], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[5], v[4], EdgeType.DIRECTED);
    }

    public static void main(String[] args) {
        new DrawnIconVertexDemo();
    }
}

