/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import edu.uci.ics.jung.algorithms.shortestpath.PrimMinimumSpanningTree;
import edu.uci.ics.jung.graph.DelegateTree;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.UndirectedSparseMultigraph;
import junit.framework.TestCase;

public class TestPrimMinimumSpanningTree
extends TestCase {
    public void testSimpleTree() {
        DelegateTree<String, Integer> tree = new DelegateTree<String, Integer>();
        tree.addVertex("A");
        tree.addEdge(Integer.valueOf(0), "A", "B0");
        tree.addEdge(Integer.valueOf(1), "A", "B1");
        PrimMinimumSpanningTree<String, Integer> pmst = new PrimMinimumSpanningTree<String, Integer>(DelegateTree.getFactory());
        pmst.apply(tree);
    }

    public void testDAG() {
        DirectedSparseMultigraph<String, Integer> graph = new DirectedSparseMultigraph<String, Integer>();
        graph.addVertex("B0");
        graph.addEdge(Integer.valueOf(0), "A", "B0");
        graph.addEdge(Integer.valueOf(1), "A", "B1");
        PrimMinimumSpanningTree<String, Integer> pmst = new PrimMinimumSpanningTree<String, Integer>(DelegateTree.getFactory());
        pmst.apply(graph);
    }

    public void testUAG() {
        UndirectedSparseMultigraph<String, Integer> graph = new UndirectedSparseMultigraph<String, Integer>();
        graph.addVertex("B0");
        graph.addEdge(Integer.valueOf(0), "A", "B0");
        graph.addEdge(Integer.valueOf(1), "A", "B1");
        PrimMinimumSpanningTree<String, Integer> pmst = new PrimMinimumSpanningTree<String, Integer>(DelegateTree.getFactory());
        pmst.apply(graph);
    }
}

