/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.generators.random;

import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.generators.random.BarabasiAlbertGenerator;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseGraph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import edu.uci.ics.jung.graph.UndirectedSparseMultigraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestBarabasiAlbert
extends TestCase {
    protected Supplier<Graph<Integer, Number>> graphFactory;
    protected Supplier<Integer> vertexFactory;
    protected Supplier<Number> edgeFactory;
    protected int init_vertices = 1;
    protected int edges_to_add_per_timestep = 1;
    protected int random_seed = 0;
    protected int num_timesteps = 10;
    protected int num_tests = 10;

    public static Test suite() {
        return new TestSuite(TestBarabasiAlbert.class);
    }

    protected void setUp() {
        this.graphFactory = new Supplier<Graph<Integer, Number>>(){

            public Graph<Integer, Number> get() {
                return new SparseMultigraph<Integer, Number>();
            }
        };
        this.vertexFactory = new Supplier<Integer>(){
            int count;

            public Integer get() {
                return this.count++;
            }
        };
        this.edgeFactory = new Supplier<Number>(){
            int count;

            public Number get() {
                return this.count++;
            }
        };
    }

    private Graph<Integer, Number> generateAndTestSizeOfBarabasiAlbertGraph(Supplier<Graph<Integer, Number>> graphFactory, Supplier<Integer> vertexFactory, Supplier<Number> edgeFactory, int init_vertices, int edges_to_add_per_timestep, int random_seed, int num_tests) {
        BarabasiAlbertGenerator<Integer, Number> generator = new BarabasiAlbertGenerator<Integer, Number>(graphFactory, vertexFactory, edgeFactory, init_vertices, edges_to_add_per_timestep, random_seed, new HashSet());
        Object graph = null;
        for (int i = 1; i <= num_tests; ++i) {
            generator.evolveGraph(this.num_timesteps);
            graph = generator.get();
            TestBarabasiAlbert.assertEquals((int)graph.getVertexCount(), (int)(i * this.num_timesteps + init_vertices));
            TestBarabasiAlbert.assertEquals((int)graph.getEdgeCount(), (int)(edges_to_add_per_timestep * (i * this.num_timesteps)));
        }
        return graph;
    }

    public void testMultigraphCreation() {
        this.generateAndTestSizeOfBarabasiAlbertGraph(this.graphFactory, this.vertexFactory, this.edgeFactory, this.init_vertices, this.edges_to_add_per_timestep, this.random_seed, this.num_tests);
    }

    public void testDirectedMultigraphCreation() {
        this.graphFactory = new Supplier<Graph<Integer, Number>>(){

            public Graph<Integer, Number> get() {
                return new DirectedSparseMultigraph<Integer, Number>();
            }
        };
        this.generateAndTestSizeOfBarabasiAlbertGraph(this.graphFactory, this.vertexFactory, this.edgeFactory, this.init_vertices, this.edges_to_add_per_timestep, this.random_seed, this.num_tests);
    }

    public void testUndirectedMultigraphCreation() {
        this.graphFactory = new Supplier<Graph<Integer, Number>>(){

            public Graph<Integer, Number> get() {
                return new UndirectedSparseMultigraph<Integer, Number>();
            }
        };
        this.generateAndTestSizeOfBarabasiAlbertGraph(this.graphFactory, this.vertexFactory, this.edgeFactory, this.init_vertices, this.edges_to_add_per_timestep, this.random_seed, this.num_tests);
    }

    public void testGraphCreation() {
        this.graphFactory = new Supplier<Graph<Integer, Number>>(){

            public Graph<Integer, Number> get() {
                return new SparseGraph<Integer, Number>();
            }
        };
        this.generateAndTestSizeOfBarabasiAlbertGraph(this.graphFactory, this.vertexFactory, this.edgeFactory, this.init_vertices, this.edges_to_add_per_timestep, this.random_seed, this.num_tests);
    }

    public void testDirectedGraphCreation() {
        this.graphFactory = new Supplier<Graph<Integer, Number>>(){

            public Graph<Integer, Number> get() {
                return new DirectedSparseGraph<Integer, Number>();
            }
        };
        this.generateAndTestSizeOfBarabasiAlbertGraph(this.graphFactory, this.vertexFactory, this.edgeFactory, this.init_vertices, this.edges_to_add_per_timestep, this.random_seed, this.num_tests);
    }

    public void testUndirectedGraphCreation() {
        this.graphFactory = new Supplier<Graph<Integer, Number>>(){

            public Graph<Integer, Number> get() {
                return new UndirectedSparseGraph<Integer, Number>();
            }
        };
        this.generateAndTestSizeOfBarabasiAlbertGraph(this.graphFactory, this.vertexFactory, this.edgeFactory, this.init_vertices, this.edges_to_add_per_timestep, this.random_seed, this.num_tests);
    }

    public void testNoSelfLoops() {
        this.graphFactory = new Supplier<Graph<Integer, Number>>(){

            public Graph<Integer, Number> get() {
                return new UndirectedSparseGraph<Integer, Number>(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public boolean addEdge(Number edge, Pair<? extends Integer> endpoints, EdgeType edgeType) {
                        Integer v2;
                        if (endpoints == null) {
                            throw new IllegalArgumentException("endpoints may not be null");
                        }
                        Integer v1 = endpoints.getFirst();
                        if (v1.equals(v2 = endpoints.getSecond())) {
                            throw new IllegalArgumentException("No self-loops");
                        }
                        return super.addEdge(edge, endpoints, edgeType);
                    }
                };
            }
        };
        this.generateAndTestSizeOfBarabasiAlbertGraph(this.graphFactory, this.vertexFactory, this.edgeFactory, this.init_vertices, this.edges_to_add_per_timestep, this.random_seed, this.num_tests);
    }

    public void testPreconditions() {
        try {
            this.generateAndTestSizeOfBarabasiAlbertGraph(this.graphFactory, this.vertexFactory, this.edgeFactory, 0, this.edges_to_add_per_timestep, this.random_seed, this.num_tests);
            TestBarabasiAlbert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.generateAndTestSizeOfBarabasiAlbertGraph(this.graphFactory, this.vertexFactory, this.edgeFactory, -1, this.edges_to_add_per_timestep, this.random_seed, this.num_tests);
            TestBarabasiAlbert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.generateAndTestSizeOfBarabasiAlbertGraph(this.graphFactory, this.vertexFactory, this.edgeFactory, this.init_vertices, 0, this.random_seed, this.num_tests);
            TestBarabasiAlbert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.generateAndTestSizeOfBarabasiAlbertGraph(this.graphFactory, this.vertexFactory, this.edgeFactory, this.init_vertices, -1, this.random_seed, this.num_tests);
            TestBarabasiAlbert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.generateAndTestSizeOfBarabasiAlbertGraph(this.graphFactory, this.vertexFactory, this.edgeFactory, 2, 3, this.random_seed, this.num_tests);
            TestBarabasiAlbert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEveryNodeHasCorrectMinimumNumberOfEdges() {
        Graph<Integer, Number> graph = this.generateAndTestSizeOfBarabasiAlbertGraph(this.graphFactory, this.vertexFactory, this.edgeFactory, this.init_vertices, this.edges_to_add_per_timestep, this.random_seed, this.num_tests);
        for (Integer v : graph.getVertices()) {
            TestBarabasiAlbert.assertTrue((graph.outDegree(v) >= this.edges_to_add_per_timestep ? 1 : 0) != 0);
        }
    }

    public void testNotEveryEdgeToOneNode() {
        Graph<Integer, Number> graph = this.generateAndTestSizeOfBarabasiAlbertGraph(this.graphFactory, this.vertexFactory, this.edgeFactory, this.init_vertices, this.edges_to_add_per_timestep, this.random_seed, this.num_tests);
        for (Integer v : graph.getVertices()) {
            TestBarabasiAlbert.assertTrue((graph.inDegree(v) < graph.getEdgeCount() ? 1 : 0) != 0);
        }
    }
}

