/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.generators;

import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.generators.Lattice2DGenerator;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.UndirectedSparseMultigraph;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestLattice2D
extends TestCase {
    protected Supplier<UndirectedGraph<String, Number>> undirectedGraphFactory;
    protected Supplier<DirectedGraph<String, Number>> directedGraphFactory;
    protected Supplier<String> vertexFactory;
    protected Supplier<Number> edgeFactory;

    protected void setUp() {
        this.undirectedGraphFactory = new Supplier<UndirectedGraph<String, Number>>(){

            public UndirectedGraph<String, Number> get() {
                return new UndirectedSparseMultigraph<String, Number>();
            }
        };
        this.directedGraphFactory = new Supplier<DirectedGraph<String, Number>>(){

            public DirectedGraph<String, Number> get() {
                return new DirectedSparseMultigraph<String, Number>();
            }
        };
        this.vertexFactory = new Supplier<String>(){
            int count;

            public String get() {
                return Character.toString((char)(65 + this.count++));
            }
        };
        this.edgeFactory = new Supplier<Number>(){
            int count;

            public Number get() {
                return this.count++;
            }
        };
    }

    public void testCreateSingular() {
        try {
            this.generate(1, 0, 0);
            TestLattice2D.fail((String)"Did not reject lattice of size < 2");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testget() {
        for (int i = 3; i <= 10; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    Lattice2DGenerator<String, Number> generator = this.generate(i, j, k);
                    Object graph = generator.get();
                    Assert.assertEquals((int)(i * i), (int)graph.getVertexCount());
                    this.checkEdgeCount(generator, (Graph<String, Number>)graph);
                }
            }
        }
    }

    protected Lattice2DGenerator<String, Number> generate(int i, int j, int k) {
        return new Lattice2DGenerator<String, Number>((Supplier<Graph<String, Number>>)(k == 0 ? this.undirectedGraphFactory : this.directedGraphFactory), this.vertexFactory, this.edgeFactory, i, j == 0);
    }

    protected void checkEdgeCount(Lattice2DGenerator<String, Number> generator, Graph<String, Number> graph) {
        Assert.assertEquals((int)generator.getGridEdgeCount(), (int)graph.getEdgeCount());
    }
}

