/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.flows;

import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.flows.EdmondsKarpMaxFlow;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.util.HashMap;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestEdmondsKarpMaxFlow
extends TestCase {
    public static Test suite() {
        return new TestSuite(TestEdmondsKarpMaxFlow.class);
    }

    protected void setUp() {
    }

    public void testSanityChecks() {
        DirectedSparseMultigraph g = new DirectedSparseMultigraph();
        Integer source = new Integer(1);
        Integer sink = new Integer(2);
        g.addVertex(source);
        g.addVertex(sink);
        Integer v = new Integer(3);
        DirectedSparseMultigraph h = new DirectedSparseMultigraph();
        Integer w = new Integer(4);
        g.addVertex(w);
        try {
            new EdmondsKarpMaxFlow(g, source, source, null, null, null);
            TestEdmondsKarpMaxFlow.fail((String)"source and sink vertices not distinct");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new EdmondsKarpMaxFlow(h, source, w, null, null, null);
            TestEdmondsKarpMaxFlow.fail((String)"source and sink vertices not both part of specified graph");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new EdmondsKarpMaxFlow(g, source, v, null, null, null);
            TestEdmondsKarpMaxFlow.fail((String)"source and sink vertices not both part of specified graph");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    public void testSimpleFlow() {
        void var9_14;
        DirectedSparseMultigraph<Integer, Object> graph = new DirectedSparseMultigraph<Integer, Object>();
        Supplier<Number> edgeFactory = new Supplier<Number>(){
            int count = 0;

            public Number get() {
                return this.count++;
            }
        };
        HashMap<Integer, Integer> edgeCapacityMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < 6; ++i) {
            graph.addVertex(i);
        }
        HashMap edgeFlowMap = new HashMap();
        graph.addEdge(edgeFactory.get(), 0, 1, EdgeType.DIRECTED);
        edgeCapacityMap.put(0, 16);
        graph.addEdge(edgeFactory.get(), 0, 2, EdgeType.DIRECTED);
        edgeCapacityMap.put(1, 13);
        graph.addEdge(edgeFactory.get(), 1, 2, EdgeType.DIRECTED);
        edgeCapacityMap.put(2, 6);
        graph.addEdge(edgeFactory.get(), 1, 3, EdgeType.DIRECTED);
        edgeCapacityMap.put(3, 12);
        graph.addEdge(edgeFactory.get(), 2, 4, EdgeType.DIRECTED);
        edgeCapacityMap.put(4, 14);
        graph.addEdge(edgeFactory.get(), 3, 2, EdgeType.DIRECTED);
        edgeCapacityMap.put(5, 9);
        graph.addEdge(edgeFactory.get(), 3, 5, EdgeType.DIRECTED);
        edgeCapacityMap.put(6, 20);
        graph.addEdge(edgeFactory.get(), 4, 3, EdgeType.DIRECTED);
        edgeCapacityMap.put(7, 7);
        graph.addEdge(edgeFactory.get(), 4, 5, EdgeType.DIRECTED);
        edgeCapacityMap.put(8, 4);
        EdmondsKarpMaxFlow<Integer, Number> ek = new EdmondsKarpMaxFlow<Integer, Number>(graph, 0, 5, Functions.forMap(edgeCapacityMap, null), edgeFlowMap, edgeFactory);
        ek.evaluate();
        TestEdmondsKarpMaxFlow.assertTrue((ek.getMaxFlow() == 23 ? 1 : 0) != 0);
        Set<Integer> nodesInS = ek.getNodesInSourcePartition();
        TestEdmondsKarpMaxFlow.assertEquals((int)4, (int)nodesInS.size());
        for (Number number : nodesInS) {
            Assert.assertTrue((number.intValue() != 3 && number.intValue() != 5 ? 1 : 0) != 0);
        }
        Set<Integer> nodesInT = ek.getNodesInSinkPartition();
        TestEdmondsKarpMaxFlow.assertEquals((int)2, (int)nodesInT.size());
        for (Number number : nodesInT) {
            Assert.assertTrue((number.intValue() == 3 || number.intValue() == 5 ? 1 : 0) != 0);
        }
        Set<Number> set = ek.getMinCutEdges();
        boolean bl = false;
        for (Number e : set) {
            Number flow = (Number)edgeFlowMap.get(e);
            var9_14 += flow.intValue();
        }
        Assert.assertEquals((int)23, (int)var9_14);
        Assert.assertEquals((int)3, (int)set.size());
    }

    public void testAnotherSimpleFlow() {
        DirectedSparseMultigraph<Integer, Object> graph = new DirectedSparseMultigraph<Integer, Object>();
        Supplier<Number> edgeFactory = new Supplier<Number>(){
            int count = 0;

            public Number get() {
                return this.count++;
            }
        };
        HashMap<Integer, Integer> edgeCapacityMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < 6; ++i) {
            graph.addVertex(i);
        }
        HashMap edgeFlowMap = new HashMap();
        graph.addEdge(edgeFactory.get(), 0, 1, EdgeType.DIRECTED);
        edgeCapacityMap.put(0, 5);
        graph.addEdge(edgeFactory.get(), 0, 2, EdgeType.DIRECTED);
        edgeCapacityMap.put(1, 3);
        graph.addEdge(edgeFactory.get(), 1, 5, EdgeType.DIRECTED);
        edgeCapacityMap.put(2, 2);
        graph.addEdge(edgeFactory.get(), 1, 2, EdgeType.DIRECTED);
        edgeCapacityMap.put(3, 8);
        graph.addEdge(edgeFactory.get(), 2, 3, EdgeType.DIRECTED);
        edgeCapacityMap.put(4, 4);
        graph.addEdge(edgeFactory.get(), 2, 4, EdgeType.DIRECTED);
        edgeCapacityMap.put(5, 2);
        graph.addEdge(edgeFactory.get(), 3, 4, EdgeType.DIRECTED);
        edgeCapacityMap.put(6, 3);
        graph.addEdge(edgeFactory.get(), 3, 5, EdgeType.DIRECTED);
        edgeCapacityMap.put(7, 6);
        graph.addEdge(edgeFactory.get(), 4, 5, EdgeType.DIRECTED);
        edgeCapacityMap.put(8, 1);
        EdmondsKarpMaxFlow<Integer, Number> ek = new EdmondsKarpMaxFlow<Integer, Number>(graph, 0, 5, Functions.forMap(edgeCapacityMap, null), edgeFlowMap, edgeFactory);
        ek.evaluate();
        TestEdmondsKarpMaxFlow.assertTrue((ek.getMaxFlow() == 7 ? 1 : 0) != 0);
    }
}

